/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.table;

import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.table.ColumnStatisticsInfo;
import alluxio.grpc.table.Schema;
import alluxio.grpc.table.TableInfo;
import alluxio.master.table.Database;
import alluxio.master.table.Partition;
import alluxio.master.table.PartitionScheme;
import alluxio.proto.journal.Table;
import alluxio.table.common.UdbPartition;
import alluxio.table.common.transform.TransformContext;
import alluxio.table.common.transform.TransformDefinition;
import alluxio.table.common.transform.TransformPlan;
import alluxio.table.common.udb.UdbTable;
import alluxio.util.CommonUtils;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class Table {
    private static final Logger LOG = LoggerFactory.getLogger(Table.class);
    private static final long UNDEFINED_VERSION = -1L;
    private static final int PARTITIONS_CHUNK_SIZE = Configuration.getInt((PropertyKey)PropertyKey.TABLE_JOURNAL_PARTITIONS_CHUNK_SIZE);
    public static final long FIRST_VERSION = 1L;
    private final Database mDatabase;
    private final String mName;
    private final long mVersion;
    private final long mVersionCreationTime;
    private final long mPreviousVersion;
    private final Schema mSchema;
    private final PartitionScheme mPartitionScheme;
    private final String mOwner;
    private final List<ColumnStatisticsInfo> mStatistics;
    private final Map<String, String> mParameters;

    private Table(Database database, UdbTable udbTable, @Nullable Table previousTable) {
        this.mDatabase = database;
        this.mVersion = previousTable == null ? 1L : previousTable.mVersion + 1L;
        this.mPreviousVersion = previousTable == null ? -1L : previousTable.mVersion;
        this.mVersionCreationTime = CommonUtils.getCurrentMs();
        this.mName = udbTable.getName();
        this.mSchema = udbTable.getSchema();
        this.mOwner = udbTable.getOwner() == null ? "" : udbTable.getOwner();
        this.mStatistics = udbTable.getStatistics();
        this.mParameters = new HashMap<String, String>(udbTable.getParameters());
        List<Object> partitions = new ArrayList(udbTable.getPartitions().size());
        if (previousTable != null) {
            Map existingPartitions = previousTable.mPartitionScheme.getPartitions().stream().collect(Collectors.toMap(Partition::getSpec, Function.identity()));
            for (UdbPartition udbPartition2 : udbTable.getPartitions()) {
                Partition newPartition = (Partition)existingPartitions.get(udbPartition2.getSpec());
                if (newPartition == null) {
                    newPartition = new Partition(udbPartition2);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Existing table {}.{} adding UDB partition: {}", new Object[]{database.getName(), this.mName, udbPartition2});
                    }
                } else if (!newPartition.getBaseLayout().equals(udbPartition2.getLayout())) {
                    newPartition = newPartition.createNext(udbPartition2);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Existing table {}.{} updating UDB partition {}", new Object[]{database.getName(), this.mName, udbPartition2});
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("Existing table {}.{} keeping partition spec: {}", new Object[]{database.getName(), this.mName, udbPartition2});
                }
                partitions.add(newPartition);
            }
            LOG.info("Updating existing table {}.{} with {} total partitions.", new Object[]{database.getName(), this.mName, partitions.size()});
        } else {
            partitions = udbTable.getPartitions().stream().map(Partition::new).collect(Collectors.toList());
            LOG.info("Creating new table {}.{} with {} total partitions.", new Object[]{database.getName(), this.mName, partitions.size()});
            if (LOG.isDebugEnabled()) {
                udbTable.getPartitions().stream().forEach(udbPartition -> LOG.debug("New table {}.{} adding UDB partition: {}.", new Object[]{database.getName(), this.mName, udbPartition}));
            }
        }
        this.mPartitionScheme = PartitionScheme.create(partitions, udbTable.getLayout(), udbTable.getPartitionCols());
    }

    private Table(Database database, Table.AddTableEntry entry) {
        List<Partition> partitions = entry.getPartitionsList().stream().map(p -> Partition.fromProto(database.getContext().getLayoutRegistry(), p)).collect(Collectors.toList());
        this.mDatabase = database;
        this.mName = entry.getTableName();
        this.mPreviousVersion = entry.getPreviousVersion();
        this.mVersion = entry.getVersion();
        this.mVersionCreationTime = entry.getVersionCreationTime();
        this.mSchema = entry.getSchema();
        this.mPartitionScheme = PartitionScheme.create(partitions, entry.getLayout(), entry.getPartitionColsList());
        this.mOwner = entry.getOwner();
        this.mStatistics = entry.getTableStatsList();
        this.mParameters = new HashMap<String, String>(entry.getParametersMap());
    }

    public static Table create(Database database, UdbTable udbTable, @Nullable Table previousTable) {
        if (previousTable != null && !previousTable.shouldSync(udbTable)) {
            return null;
        }
        return new Table(database, udbTable, previousTable);
    }

    public static Table create(Database database, Table.AddTableEntry entry) {
        return new Table(database, entry);
    }

    public void addPartitions(Table.AddTablePartitionsEntry entry) {
        this.mPartitionScheme.addPartitions(entry.getPartitionsList().stream().map(p -> Partition.fromProto(this.mDatabase.getContext().getLayoutRegistry(), p)).collect(Collectors.toList()));
    }

    public String getName() {
        return this.mName;
    }

    public Partition getPartition(String spec) {
        return this.mPartitionScheme.getPartition(spec);
    }

    public List<Partition> getPartitions() {
        return this.mPartitionScheme.getPartitions();
    }

    public Schema getSchema() {
        return this.mSchema;
    }

    public List<ColumnStatisticsInfo> getStatistics() {
        return this.mStatistics;
    }

    public long getVersion() {
        return this.mVersion;
    }

    public long getPreviousVersion() {
        return this.mPreviousVersion;
    }

    public List<TransformPlan> getTransformPlans(TransformDefinition definition) throws IOException {
        ArrayList<TransformPlan> plans = new ArrayList<TransformPlan>(this.getPartitions().size());
        for (Partition partition : this.getPartitions()) {
            if (partition.isTransformed(definition.getDefinition())) continue;
            TransformContext transformContext = new TransformContext(this.mDatabase.getName(), this.mName, partition.getSpec());
            plans.add(partition.getTransformPlan(transformContext, definition));
        }
        return plans;
    }

    public boolean shouldSync(UdbTable udbTable) {
        if (!(Objects.equals(this.mName, udbTable.getName()) && Objects.equals(this.mSchema, udbTable.getSchema()) && Objects.equals(this.mOwner, udbTable.getOwner()) && Objects.equals(this.mStatistics, udbTable.getStatistics()) && Objects.equals(this.mParameters, udbTable.getParameters()))) {
            return true;
        }
        Map existingPartitions = this.mPartitionScheme.getPartitions().stream().collect(Collectors.toMap(Partition::getSpec, Function.identity()));
        if (existingPartitions.size() != udbTable.getPartitions().size()) {
            return true;
        }
        for (UdbPartition udbPartition : udbTable.getPartitions()) {
            Partition newPartition = (Partition)existingPartitions.get(udbPartition.getSpec());
            if (newPartition != null && newPartition.getBaseLayout().equals(udbPartition.getLayout())) continue;
            return true;
        }
        return false;
    }

    public TableInfo toProto() {
        TableInfo.Builder builder = TableInfo.newBuilder().setDbName(this.mDatabase.getName()).setTableName(this.mName).setSchema(this.mSchema).setOwner(this.mOwner).putAllParameters(this.mParameters).addAllPartitionCols(this.mPartitionScheme.getPartitionCols()).setLayout(this.mPartitionScheme.getTableLayout()).setPreviousVersion(this.mPreviousVersion).setVersion(this.mVersion).setVersionCreationTime(this.mVersionCreationTime);
        return builder.build();
    }

    public Table.AddTableEntry getTableJournalProto() {
        Table.AddTableEntry.Builder builder = Table.AddTableEntry.newBuilder().setDbName(this.mDatabase.getName()).setTableName(this.mName).addAllTableStats(this.mStatistics).setSchema(this.mSchema).setOwner(this.mOwner).putAllParameters(this.mParameters).addAllPartitionCols(this.mPartitionScheme.getPartitionCols()).setLayout(this.mPartitionScheme.getTableLayout()).setPreviousVersion(this.mPreviousVersion).setVersion(this.mVersion).setVersionCreationTime(this.mVersionCreationTime);
        List<Partition> partitions = this.getPartitions();
        if (partitions.size() <= PARTITIONS_CHUNK_SIZE) {
            builder.addAllPartitions((Iterable)partitions.stream().map(Partition::toProto).collect(Collectors.toList()));
        }
        return builder.build();
    }

    public List<Table.AddTablePartitionsEntry> getTablePartitionsJournalProto() {
        ArrayList<Table.AddTablePartitionsEntry> partitionEntries = new ArrayList<Table.AddTablePartitionsEntry>();
        List<Partition> partitions = this.getPartitions();
        if (partitions.size() <= PARTITIONS_CHUNK_SIZE) {
            return partitionEntries;
        }
        for (List partitionChunk : Lists.partition(partitions, (int)PARTITIONS_CHUNK_SIZE)) {
            partitionEntries.add(Table.AddTablePartitionsEntry.newBuilder().setDbName(this.mDatabase.getName()).setTableName(this.mName).setVersion(this.mVersion).addAllPartitions((Iterable)partitionChunk.stream().map(Partition::toProto).collect(Collectors.toList())).build());
        }
        return partitionEntries;
    }
}

