/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.table;

import alluxio.grpc.table.Partition;
import alluxio.grpc.table.PartitionSpec;
import alluxio.table.common.Layout;
import alluxio.table.common.LayoutRegistry;
import alluxio.table.common.UdbPartition;
import alluxio.table.common.transform.TransformContext;
import alluxio.table.common.transform.TransformDefinition;
import alluxio.table.common.transform.TransformPlan;
import alluxio.util.CommonUtils;
import java.io.IOException;
import java.util.List;

public class Partition {
    private static final long FIRST_VERSION = 1L;
    private final String mPartitionSpec;
    private final Layout mBaseLayout;
    private final long mVersion;
    private final long mVersionCreationTime;
    private volatile Transformation mTransformation;

    private Partition(String partitionSpec, Layout baseLayout, long version, long versionCreationTime) {
        this.mPartitionSpec = partitionSpec;
        this.mBaseLayout = baseLayout;
        this.mVersion = version;
        this.mVersionCreationTime = versionCreationTime;
    }

    public Partition(UdbPartition udbPartition) {
        this(udbPartition.getSpec(), udbPartition.getLayout(), 1L, CommonUtils.getCurrentMs());
    }

    public Partition createNext(UdbPartition udbPartition) {
        return new Partition(udbPartition.getSpec(), udbPartition.getLayout(), this.getVersion() + 1L, CommonUtils.getCurrentMs());
    }

    public Layout getLayout() {
        return this.mTransformation == null ? this.mBaseLayout : this.mTransformation.getLayout();
    }

    public Layout getBaseLayout() {
        return this.mBaseLayout;
    }

    public long getVersion() {
        return this.mVersion;
    }

    public void transform(String definition, Layout layout) {
        this.mTransformation = new Transformation(definition, layout);
    }

    public boolean isTransformed(String definition) {
        return this.mTransformation != null && this.mTransformation.getDefinition().equals(definition);
    }

    public String getSpec() {
        return this.mPartitionSpec;
    }

    public TransformPlan getTransformPlan(TransformContext transformContext, TransformDefinition definition) throws IOException {
        return this.mBaseLayout.getTransformPlan(transformContext, definition);
    }

    public alluxio.grpc.table.Partition toProto() {
        Partition.Builder builder = alluxio.grpc.table.Partition.newBuilder().setPartitionSpec(PartitionSpec.newBuilder().setSpec(this.mPartitionSpec).build()).setBaseLayout(this.mBaseLayout.toProto()).setVersion(this.mVersion).setVersionCreationTime(this.mVersionCreationTime);
        if (this.mTransformation != null) {
            builder.addTransformations(this.mTransformation.toProto());
        }
        return builder.build();
    }

    public static Partition fromProto(LayoutRegistry layoutRegistry, alluxio.grpc.table.Partition proto) {
        Partition partition = new Partition(proto.getPartitionSpec().getSpec(), layoutRegistry.create(proto.getBaseLayout()), proto.getVersion(), proto.getVersionCreationTime());
        List transformations = proto.getTransformationsList();
        if (!transformations.isEmpty()) {
            partition.mTransformation = Transformation.fromProto(layoutRegistry, (alluxio.grpc.table.Transformation)transformations.get(0));
        }
        return partition;
    }

    private static final class Transformation {
        private String mDefinition;
        private Layout mLayout;

        public Transformation(String definition, Layout layout) {
            this.mDefinition = definition;
            this.mLayout = layout;
        }

        public String getDefinition() {
            return this.mDefinition;
        }

        public Layout getLayout() {
            return this.mLayout;
        }

        public alluxio.grpc.table.Transformation toProto() {
            return alluxio.grpc.table.Transformation.newBuilder().setDefinition(this.mDefinition).setLayout(this.mLayout.toProto()).build();
        }

        public static Transformation fromProto(LayoutRegistry layoutRegistry, alluxio.grpc.table.Transformation proto) {
            return new Transformation(proto.getDefinition(), layoutRegistry.create(proto.getLayout()));
        }
    }
}

