/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.table;

import alluxio.collections.Pair;
import alluxio.grpc.table.Range;
import alluxio.grpc.table.Value;
import java.util.ArrayList;
import java.util.List;

public abstract class Domain<T> {
    abstract boolean isInDomain(T var1);

    public static Domain parseFrom(alluxio.grpc.table.Domain domain) {
        if (domain.hasAllOrNone()) {
            return new AllOrNoneDomain(domain.getAllOrNone().getAll());
        }
        if (domain.hasEquatable()) {
            return new EquatableDomain(domain.getEquatable().getWhiteList(), domain.getEquatable().getCandidatesList());
        }
        if (domain.hasRange()) {
            return new RangeDomain(domain.getRange().getRangesList());
        }
        return new AllOrNoneDomain(false);
    }

    private static Comparable convert(Value candidate) {
        if (candidate.hasStringType()) {
            return candidate.getStringType();
        }
        if (candidate.hasBooleanType()) {
            return Boolean.valueOf(candidate.getBooleanType());
        }
        if (candidate.hasDoubleType()) {
            return Double.valueOf(candidate.getDoubleType());
        }
        if (candidate.hasLongType()) {
            return Long.valueOf(candidate.getLongType());
        }
        return null;
    }

    private static class RangeDomain
    extends Domain {
        private List<Pair<Comparable, Comparable>> mRanges = new ArrayList<Pair<Comparable, Comparable>>();

        public RangeDomain(List<Range> rangesList) {
            for (Range range : rangesList) {
                this.mRanges.add((Pair<Comparable, Comparable>)new Pair((Object)Domain.convert(range.getLow()), (Object)Domain.convert(range.getHigh())));
            }
        }

        boolean isInDomain(Object obj) {
            for (Pair<Comparable, Comparable> pair : this.mRanges) {
                if (pair.getFirst() != null && ((Comparable)pair.getFirst()).compareTo(obj) > 0 || pair.getSecond() != null && ((Comparable)pair.getSecond()).compareTo(obj) < 0) continue;
                return true;
            }
            return false;
        }
    }

    private static class EquatableDomain<T>
    extends Domain<T> {
        private boolean mWhiteList;
        private List<Object> mObjects;

        public EquatableDomain(boolean whiteList, List<Value> candidatesList) {
            this.mWhiteList = whiteList;
            this.mObjects = new ArrayList<Object>();
            for (Value candidate : candidatesList) {
                this.mObjects.add(Domain.convert(candidate));
            }
        }

        @Override
        boolean isInDomain(Object obj) {
            return this.mWhiteList == this.mObjects.contains(obj);
        }
    }

    private static class AllOrNoneDomain
    extends Domain {
        private boolean mAll;

        public AllOrNoneDomain(boolean all) {
            this.mAll = all;
        }

        boolean isInDomain(Object obj) {
            return this.mAll;
        }
    }
}

