/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.table;

import alluxio.table.common.udb.UdbBypassSpec;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class DbConfig {
    private final BypassEntry mBypassEntry;

    @JsonCreator
    public DbConfig(@JsonProperty(value="bypass") @Nullable BypassEntry bypassEntry) {
        this.mBypassEntry = bypassEntry == null ? new BypassEntry(Collections.emptySet()) : bypassEntry;
    }

    public static DbConfig empty() {
        return new DbConfig(new BypassEntry(Collections.emptySet()));
    }

    public BypassEntry getBypassEntry() {
        return this.mBypassEntry;
    }

    public UdbBypassSpec getUdbBypassSpec() {
        return this.mBypassEntry.toUdbBypassSpec();
    }

    public static class BypassTableEntryDeserializer
    extends JsonDeserializer<BypassTableEntry> {
        public BypassTableEntry deserialize(JsonParser jp, DeserializationContext cxt) throws IOException, JsonProcessingException {
            Set partitions;
            String tableName;
            ObjectMapper mapper = (ObjectMapper)jp.getCodec();
            JsonNode node = (JsonNode)mapper.readTree(jp);
            if (!node.isTextual() && !node.isObject()) {
                throw new JsonParseException(mapper.treeAsTokens((TreeNode)node), "invalid syntax");
            }
            if (node.isTextual()) {
                tableName = node.asText();
                partitions = Collections.emptySet();
            } else {
                if (!node.hasNonNull("table")) {
                    throw new JsonParseException(mapper.treeAsTokens((TreeNode)node), "missing table name");
                }
                tableName = node.get("table").asText();
                JsonNode partitionsList = node.get("partitions");
                partitions = (Set)mapper.convertValue((Object)partitionsList, (TypeReference)new TypeReference<Set<String>>(){});
                if (partitions == null) {
                    partitions = Collections.emptySet();
                }
            }
            return new BypassTableEntry(tableName, partitions);
        }
    }

    @JsonDeserialize(using=BypassTableEntryDeserializer.class)
    public static class BypassTableEntry {
        private final String mTableName;
        private final Set<String> mPartitions;

        @JsonCreator
        public BypassTableEntry(@JsonProperty(value="table") String tableName, @JsonProperty(value="partitions") Set<String> partitions) {
            Preconditions.checkArgument((!tableName.isEmpty() ? 1 : 0) != 0, (Object)"empty table name");
            this.mTableName = tableName;
            this.mPartitions = partitions;
        }

        public String getTable() {
            return this.mTableName;
        }

        public Set<String> getPartitions() {
            return this.mPartitions;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (this.getClass() != other.getClass()) {
                return false;
            }
            BypassTableEntry entry = (BypassTableEntry)other;
            return Objects.equals(this.mTableName, entry.mTableName);
        }

        public int hashCode() {
            return Objects.hashCode(this.mTableName);
        }
    }

    public static final class BypassEntry {
        @JsonProperty(value="tables")
        private final Set<BypassTableEntry> mEntries;

        @JsonCreator
        public BypassEntry(@JsonProperty(value="tables") @Nullable Set<BypassTableEntry> entries) {
            this.mEntries = entries == null ? Collections.emptySet() : entries;
        }

        public UdbBypassSpec toUdbBypassSpec() {
            Map<String, Set> map = this.mEntries.stream().collect(Collectors.toMap(BypassTableEntry::getTable, BypassTableEntry::getPartitions));
            return new UdbBypassSpec(map);
        }

        public Set<String> getBypassedTables() {
            return this.mEntries.stream().map(BypassTableEntry::getTable).collect(Collectors.toSet());
        }

        public Set<BypassTableEntry> getBypassTableEntries() {
            return this.mEntries;
        }
    }
}

