/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.table;

import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.status.NotFoundException;
import alluxio.grpc.table.FileStatistics;
import alluxio.grpc.table.Schema;
import alluxio.grpc.table.SyncStatus;
import alluxio.master.journal.JournalContext;
import alluxio.master.journal.Journaled;
import alluxio.master.journal.checkpoint.CheckpointName;
import alluxio.master.table.CatalogConfiguration;
import alluxio.master.table.CatalogContext;
import alluxio.master.table.CatalogProperty;
import alluxio.master.table.DatabaseInfo;
import alluxio.master.table.DbConfig;
import alluxio.master.table.Table;
import alluxio.proto.journal.Journal;
import alluxio.proto.journal.Table;
import alluxio.resource.CloseableIterator;
import alluxio.table.common.udb.UdbContext;
import alluxio.table.common.udb.UdbTable;
import alluxio.table.common.udb.UnderDatabase;
import alluxio.util.CommonUtils;
import alluxio.util.ConfigurationUtils;
import alluxio.util.executor.ExecutorServiceFactories;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Database
implements Journaled {
    private static final Logger LOG = LoggerFactory.getLogger(Database.class);
    private final CatalogContext mContext;
    private final String mType;
    private final String mName;
    private final Map<String, Table> mTables;
    private final UnderDatabase mUdb;
    private final CatalogConfiguration mConfig;
    private final Set<String> mIgnoreTables;
    private final String mConfigPath;
    private DbConfig mDbConfig;
    private final long mUdbSyncTimeoutMs = Configuration.getMs((PropertyKey)PropertyKey.TABLE_CATALOG_UDB_SYNC_TIMEOUT);
    private DatabaseInfo mDatabaseInfo;

    private Database(CatalogContext context, String type, String name, UnderDatabase udb, CatalogConfiguration config) {
        this.mContext = context;
        this.mType = type;
        this.mName = name;
        this.mTables = new ConcurrentHashMap<String, Table>();
        this.mUdb = udb;
        this.mConfig = config;
        this.mIgnoreTables = Sets.newHashSet((Iterable)ConfigurationUtils.parseAsList((String)this.mConfig.get(CatalogProperty.DB_IGNORE_TABLES), (String)","));
        this.mConfigPath = this.mConfig.get(CatalogProperty.DB_CONFIG_FILE);
        this.mDbConfig = DbConfig.empty();
    }

    public static Database create(CatalogContext catalogContext, UdbContext udbContext, String type, String name, Map<String, String> configMap) {
        CatalogConfiguration configuration = new CatalogConfiguration(configMap);
        try {
            UnderDatabase udb = udbContext.getUdbRegistry().create(udbContext, type, configuration.getUdbConfiguration(type));
            return new Database(catalogContext, type, name, udb, configuration);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Creating udb failed for database name: " + name, e);
        }
    }

    public CatalogContext getContext() {
        return this.mContext;
    }

    public String getName() {
        return this.mName;
    }

    public DatabaseInfo getDatabaseInfo() {
        return this.mDatabaseInfo;
    }

    public String getType() {
        return this.mType;
    }

    public UnderDatabase getUdb() {
        return this.mUdb;
    }

    public List<Table> getTables() {
        return new ArrayList<Table>(this.mTables.values());
    }

    public Table getTable(String tableName) throws NotFoundException {
        Table table = this.mTables.get(tableName);
        if (table == null) {
            throw new NotFoundException(ExceptionMessage.TABLE_DOES_NOT_EXIST.getMessage(new Object[]{tableName, this.mName}));
        }
        return table;
    }

    public Table createTable(String tableName, Schema schema) {
        return this.mTables.get(tableName);
    }

    public Map<String, FileStatistics> getStatistics(String tableName) {
        return Collections.emptyMap();
    }

    public Map<String, String> getConfig() {
        return this.mConfig.getMap();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SyncStatus sync(JournalContext context) throws IOException {
        int threads;
        DatabaseInfo newDbInfo;
        SyncStatus.Builder builder = SyncStatus.newBuilder();
        if (!this.mConfigPath.equals(CatalogProperty.DB_CONFIG_FILE.getDefaultValue())) {
            if (!Files.exists(Paths.get(this.mConfigPath, new String[0]), new LinkOption[0])) {
                throw new FileNotFoundException(this.mConfigPath);
            }
            ObjectMapper mapper = new ObjectMapper();
            try {
                this.mDbConfig = (DbConfig)mapper.readValue(new File(this.mConfigPath), DbConfig.class);
            }
            catch (JsonProcessingException e) {
                LOG.error("Failed to deserialize UDB config file {}, stays unsynced", (Object)this.mConfigPath, (Object)e);
                throw e;
            }
        }
        if (!(newDbInfo = this.mUdb.getDatabaseInfo()).equals((Object)this.mDatabaseInfo)) {
            this.applyAndJournal((Supplier<JournalContext>)context, Journal.JournalEntry.newBuilder().setUpdateDatabaseInfo(Database.toJournalProto(newDbInfo, this.mName)).build());
        }
        HashSet udbTableNames = new HashSet(this.mUdb.getTableNames());
        AtomicInteger tablesSynced = new AtomicInteger();
        int progressBatch = udbTableNames.size() < 100 ? udbTableNames.size() : udbTableNames.size() / 10;
        ArrayList<Callable<Void>> tasks = new ArrayList<Callable<Void>>(udbTableNames.size());
        Database thisDb = this;
        for (String tableName : udbTableNames) {
            if (this.mIgnoreTables.contains(tableName)) {
                builder.addTablesIgnored(tableName);
                tablesSynced.incrementAndGet();
                continue;
            }
            tasks.add(() -> {
                int percentage3;
                int syncedTables;
                block21: {
                    try {
                        Table previousTable = this.mTables.get(tableName);
                        UdbTable udbTable = this.mUdb.getTable(tableName, this.mDbConfig.getUdbBypassSpec());
                        Table newTable = Table.create(thisDb, udbTable, previousTable);
                        if (newTable != null) {
                            Table.AddTableEntry addTableEntry = newTable.getTableJournalProto();
                            Journal.JournalEntry entry = Journal.JournalEntry.newBuilder().setAddTable(addTableEntry).build();
                            this.applyAndJournal((Supplier<JournalContext>)context, entry);
                            newTable.getTablePartitionsJournalProto().forEach(partitionsEntry -> this.applyAndJournal((Supplier<JournalContext>)context, Journal.JournalEntry.newBuilder().setAddTablePartitions(partitionsEntry).build()));
                            SyncStatus.Builder builder2 = builder;
                            synchronized (builder2) {
                                builder.addTablesUpdated(tableName);
                            }
                        }
                        SyncStatus.Builder builder3 = builder;
                        synchronized (builder3) {
                            builder.addTablesUnchanged(tableName);
                        }
                        syncedTables = tablesSynced.incrementAndGet();
                        percentage3 = -1;
                        if (syncedTables % progressBatch != 0) break block21;
                    }
                    catch (Exception e) {
                        int percentage2;
                        int syncedTables2;
                        block22: {
                            try {
                                LOG.error(String.format("Sync thread failed for %s.%s", thisDb.mName, tableName), (Throwable)e);
                                SyncStatus.Builder percentage3 = builder;
                                synchronized (percentage3) {
                                    builder.putTablesErrors(tableName, e.toString());
                                }
                                syncedTables2 = tablesSynced.incrementAndGet();
                                percentage2 = -1;
                                if (syncedTables2 % progressBatch != 0) break block22;
                            }
                            catch (Throwable throwable) {
                                int syncedTables3 = tablesSynced.incrementAndGet();
                                int percentage4 = -1;
                                if (syncedTables3 % progressBatch == 0) {
                                    percentage4 = Math.min(Math.round(100.0f * (float)syncedTables3 / (float)udbTableNames.size()), 99);
                                }
                                if (syncedTables3 == udbTableNames.size()) {
                                    percentage4 = 100;
                                }
                                if (percentage4 != -1) {
                                    LOG.info("Syncing db {} progress: completed {} of {} tables ({}%)", new Object[]{this.mName, syncedTables3, udbTableNames.size(), percentage4});
                                }
                                throw throwable;
                            }
                            percentage2 = Math.min(Math.round(100.0f * (float)syncedTables2 / (float)udbTableNames.size()), 99);
                        }
                        if (syncedTables2 == udbTableNames.size()) {
                            percentage2 = 100;
                        }
                        if (percentage2 != -1) {
                            LOG.info("Syncing db {} progress: completed {} of {} tables ({}%)", new Object[]{this.mName, syncedTables2, udbTableNames.size(), percentage2});
                        }
                    }
                    percentage3 = Math.min(Math.round(100.0f * (float)syncedTables / (float)udbTableNames.size()), 99);
                }
                if (syncedTables == udbTableNames.size()) {
                    percentage3 = 100;
                }
                if (percentage3 != -1) {
                    LOG.info("Syncing db {} progress: completed {} of {} tables ({}%)", new Object[]{this.mName, syncedTables, udbTableNames.size(), percentage3});
                }
                return null;
            });
        }
        try {
            threads = Integer.parseInt(this.mConfig.get(CatalogProperty.DB_SYNC_THREADS));
        }
        catch (NumberFormatException e) {
            LOG.warn("Catalog property {} with value {} cannot be parsed as an int", (Object)CatalogProperty.DB_SYNC_THREADS.getName(), (Object)this.mConfig.get(CatalogProperty.DB_SYNC_THREADS));
            threads = 4;
        }
        if (threads < 1) {
            threads = 4;
        }
        ExecutorService service = ExecutorServiceFactories.fixedThreadPool((String)String.format("Catalog-Sync-%s", this.mName), (int)threads).create();
        try {
            CommonUtils.invokeAll((ExecutorService)service, tasks, (long)this.mUdbSyncTimeoutMs);
            service.shutdownNow();
        }
        catch (Exception e) {
            try {
                throw new IOException("Failed to sync database " + this.mName + ". error: " + e.toString(), e);
            }
            catch (Throwable throwable) {
                service.shutdownNow();
                String errorMessage2 = String.format("waiting for db-sync thread pool to shut down. db: %s", this.mName);
                try {
                    if (service.awaitTermination(5L, TimeUnit.SECONDS)) throw throwable;
                    LOG.warn("Timed out " + errorMessage2);
                    throw throwable;
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    LOG.warn("Interrupted while " + errorMessage2);
                }
                throw throwable;
            }
        }
        String errorMessage = String.format("waiting for db-sync thread pool to shut down. db: %s", this.mName);
        try {
            if (!service.awaitTermination(5L, TimeUnit.SECONDS)) {
                LOG.warn("Timed out " + errorMessage);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.warn("Interrupted while " + errorMessage);
        }
        Iterator<Table> iterator = this.mTables.values().iterator();
        while (iterator.hasNext()) {
            Table existingTable = iterator.next();
            if (udbTableNames.contains(existingTable.getName())) continue;
            Table.RemoveTableEntry removeTableEntry = Table.RemoveTableEntry.newBuilder().setDbName(this.mName).setTableName(existingTable.getName()).setVersion(existingTable.getVersion()).build();
            Journal.JournalEntry entry = Journal.JournalEntry.newBuilder().setRemoveTable(removeTableEntry).build();
            this.applyAndJournal((Supplier<JournalContext>)context, entry);
            builder.addTablesRemoved(existingTable.getName());
        }
        return builder.build();
    }

    public void applyAndJournal(Supplier<JournalContext> context, Journal.JournalEntry entry) {
        this.processJournalEntryInternal(entry, context.get());
    }

    public boolean processJournalEntry(Journal.JournalEntry entry) {
        return this.processJournalEntryInternal(entry, null);
    }

    private boolean processJournalEntryInternal(Journal.JournalEntry entry, @Nullable JournalContext context) {
        if (entry.hasAddTable()) {
            return this.applyAddTable(context, entry);
        }
        if (entry.hasAddTablePartitions()) {
            return this.applyAddTablePartitions(context, entry);
        }
        if (entry.hasRemoveTable()) {
            return this.applyRemoveTable(context, entry);
        }
        if (entry.hasUpdateDatabaseInfo()) {
            return this.applyUpdateDbInfo(context, entry);
        }
        return false;
    }

    private boolean applyUpdateDbInfo(@Nullable JournalContext context, Journal.JournalEntry entry) {
        Table.UpdateDatabaseInfoEntry updateDb = entry.getUpdateDatabaseInfo();
        if (!updateDb.getDbName().equals(this.mName)) {
            return false;
        }
        if (context != null) {
            context.append(entry);
        }
        this.mDatabaseInfo = new DatabaseInfo(updateDb.getLocation(), updateDb.getOwnerName(), updateDb.getOwnerType(), updateDb.getComment(), updateDb.getParameterMap());
        return true;
    }

    private boolean applyAddTable(@Nullable JournalContext context, Journal.JournalEntry entry) {
        Table.AddTableEntry addTable = entry.getAddTable();
        if (!addTable.getDbName().equals(this.mName)) {
            return false;
        }
        Table newTable = Table.create(this, addTable);
        this.mTables.compute(newTable.getName(), (key, existingTable) -> {
            boolean writeNewTable = false;
            if (existingTable == null && newTable.getVersion() == 1L) {
                LOG.info("Adding new table {}.{}", (Object)this.mName, (Object)newTable.getName());
                writeNewTable = true;
            }
            if (existingTable != null && newTable.getPreviousVersion() == existingTable.getVersion()) {
                LOG.info("Updating table {}.{} to version {}", new Object[]{this.mName, newTable.getName(), newTable.getVersion()});
                writeNewTable = true;
            }
            if (writeNewTable) {
                if (context != null) {
                    context.append(entry);
                }
                return newTable;
            }
            return existingTable;
        });
        return true;
    }

    private boolean applyAddTablePartitions(@Nullable JournalContext context, Journal.JournalEntry entry) {
        Table.AddTablePartitionsEntry addTablePartitions = entry.getAddTablePartitions();
        if (!addTablePartitions.getDbName().equals(this.mName)) {
            return false;
        }
        this.mTables.compute(addTablePartitions.getTableName(), (key, existingTable) -> {
            if (existingTable != null) {
                if (addTablePartitions.getVersion() == existingTable.getVersion()) {
                    LOG.info("Adding {} partitions to table {}.{}", new Object[]{addTablePartitions.getPartitionsCount(), this.mName, addTablePartitions.getTableName()});
                    if (context != null) {
                        context.append(entry);
                    }
                    existingTable.addPartitions(addTablePartitions);
                    return existingTable;
                }
                LOG.info("Will not add partitions to table {}.{}, because of mismatched versions. version-to-add-partitions: {} existing-version: {}", new Object[]{this.mName, addTablePartitions.getTableName(), addTablePartitions.getVersion(), existingTable.getVersion()});
            }
            LOG.debug("Cannot add partitions to table {}.{}, because it does not exist.", (Object)this.mName, (Object)addTablePartitions.getTableName());
            return existingTable;
        });
        return true;
    }

    private boolean applyRemoveTable(@Nullable JournalContext context, Journal.JournalEntry entry) {
        Table.RemoveTableEntry removeTable = entry.getRemoveTable();
        if (!removeTable.getDbName().equals(this.mName)) {
            return false;
        }
        this.mTables.compute(removeTable.getTableName(), (key, existingTable) -> {
            if (existingTable != null) {
                if (removeTable.getVersion() == existingTable.getVersion()) {
                    LOG.info("Removing table {}.{}", (Object)this.mName, (Object)removeTable.getTableName());
                    if (context != null) {
                        context.append(entry);
                    }
                    return null;
                }
                LOG.info("Will not remove table {}.{}, because of mismatched versions. version-to-delete: {} existing-version: {}", new Object[]{this.mName, removeTable.getTableName(), removeTable.getVersion(), existingTable.getVersion()});
            }
            LOG.debug("Cannot remove table {}.{}, because it does not exist.", (Object)this.mName, (Object)removeTable.getTableName());
            return existingTable;
        });
        return true;
    }

    public void resetState() {
        this.mTables.clear();
    }

    private Iterator<Journal.JournalEntry> getTableIterator() {
        final Iterator<Table> it = this.getTables().iterator();
        return new Iterator<Journal.JournalEntry>(){
            private Table mEntry = null;
            private Iterator<Table.AddTablePartitionsEntry> mPartitionIterator;

            @Override
            public boolean hasNext() {
                if (this.mEntry != null) {
                    return true;
                }
                if (this.mPartitionIterator != null && this.mPartitionIterator.hasNext()) {
                    return true;
                }
                if (it.hasNext()) {
                    this.mEntry = (Table)it.next();
                    this.mPartitionIterator = this.mEntry.getTablePartitionsJournalProto().iterator();
                    return true;
                }
                return false;
            }

            @Override
            public Journal.JournalEntry next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.mEntry != null) {
                    Table table = this.mEntry;
                    this.mEntry = null;
                    Table.AddTableEntry addTableEntry = table.getTableJournalProto();
                    return Journal.JournalEntry.newBuilder().setAddTable(addTableEntry).build();
                }
                if (this.mPartitionIterator != null && this.mPartitionIterator.hasNext()) {
                    return Journal.JournalEntry.newBuilder().setAddTablePartitions(this.mPartitionIterator.next()).build();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("GetTableIterator#Iterator#remove is not supported.");
            }
        };
    }

    public CloseableIterator<Journal.JournalEntry> getJournalEntryIterator() {
        Journal.JournalEntry entry = Journal.JournalEntry.newBuilder().setUpdateDatabaseInfo(Database.toJournalProto(this.getDatabaseInfo(), this.mName)).build();
        return CloseableIterator.noopCloseable((Iterator)Iterators.concat((Iterator)Iterators.singletonIterator((Object)entry), this.getTableIterator()));
    }

    public CheckpointName getCheckpointName() {
        return CheckpointName.TABLE_MASTER_DATABASE;
    }

    public static Table.UpdateDatabaseInfoEntry toJournalProto(DatabaseInfo dbInfo, String dbName) {
        Table.UpdateDatabaseInfoEntry.Builder builder = Table.UpdateDatabaseInfoEntry.newBuilder().setDbName(dbName).putAllParameter(dbInfo.getParameters());
        if (dbInfo.getComment() != null) {
            builder.setComment(dbInfo.getComment());
        }
        if (dbInfo.getLocation() != null) {
            builder.setLocation(dbInfo.getLocation());
        }
        if (dbInfo.getOwnerName() != null) {
            builder.setOwnerName(dbInfo.getOwnerName());
        }
        if (dbInfo.getOwnerType() != null) {
            builder.setOwnerType(dbInfo.getOwnerType());
        }
        return builder.build();
    }
}

