/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.table;

import alluxio.master.table.Partition;
import alluxio.master.table.PartitionScheme;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BasePartitionScheme
implements PartitionScheme {
    protected final List<Partition> mPartitions;
    protected final Map<String, Partition> mSpecToPartition;

    public BasePartitionScheme(List<Partition> partitions) {
        this.mPartitions = partitions;
        this.mSpecToPartition = new HashMap<String, Partition>();
        for (Partition partition : this.mPartitions) {
            this.mSpecToPartition.put(partition.getSpec(), partition);
        }
    }

    @Override
    public void addPartitions(List<Partition> partitions) {
        this.mPartitions.addAll(partitions);
        for (Partition partition : this.mPartitions) {
            this.mSpecToPartition.put(partition.getSpec(), partition);
        }
    }

    @Override
    public List<Partition> getPartitions() {
        return Collections.unmodifiableList(this.mPartitions);
    }

    @Override
    public Partition getPartition(String spec) {
        return this.mSpecToPartition.get(spec);
    }
}

