/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.HealthCheckClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.master.MasterHealthCheckClient;
import alluxio.retry.ExponentialBackoffRetry;
import alluxio.retry.RetryPolicy;
import alluxio.util.ConfigurationUtils;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AlluxioMasterMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(AlluxioMasterMonitor.class);
    public static final Supplier<RetryPolicy> TWO_MIN_EXP_BACKOFF = () -> new ExponentialBackoffRetry(50, 1000, 130);

    public static void main(String[] args) {
        if (args.length != 0) {
            LOG.warn("java -cp {} {}", (Object)"target/alluxio-2.9.0-jar-with-dependencies.jar", (Object)AlluxioMasterMonitor.class.getCanonicalName());
            LOG.warn("ignoring arguments");
        }
        AlluxioConfiguration alluxioConf = Configuration.global();
        MasterHealthCheckClient.Builder builder = new MasterHealthCheckClient.Builder(alluxioConf);
        builder.withProcessCheck(ConfigurationUtils.isHaMode((AlluxioConfiguration)alluxioConf));
        HealthCheckClient client = builder.build();
        if (!client.isServing()) {
            System.exit(1);
        }
        System.exit(0);
    }

    private AlluxioMasterMonitor() {
    }
}

