/*
 * Decompiled with CFR 0.152.
 */
package alluxio.common;

import alluxio.HealthCheckClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.exception.status.UnavailableException;
import alluxio.grpc.ServiceType;
import alluxio.retry.RetryPolicy;
import alluxio.security.user.UserState;
import alluxio.util.network.NetworkAddressUtils;
import java.net.InetSocketAddress;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcPortHealthCheckClient
implements HealthCheckClient {
    private static final Logger LOG = LoggerFactory.getLogger(RpcPortHealthCheckClient.class);
    private final InetSocketAddress mNodeAddress;
    private final ServiceType mServiceType;
    private final Supplier<RetryPolicy> mRetryPolicySupplier;
    private final AlluxioConfiguration mConf;
    private final UserState mUserState;

    public RpcPortHealthCheckClient(InetSocketAddress nodeAddress, ServiceType serviceType, Supplier<RetryPolicy> retryPolicySupplier, AlluxioConfiguration alluxioConf) {
        this.mNodeAddress = nodeAddress;
        this.mServiceType = serviceType;
        this.mRetryPolicySupplier = retryPolicySupplier;
        this.mConf = alluxioConf;
        this.mUserState = UserState.Factory.create((AlluxioConfiguration)this.mConf);
    }

    public boolean isServing() {
        RetryPolicy retry = this.mRetryPolicySupplier.get();
        while (retry.attempt()) {
            try {
                LOG.debug("Checking whether {} is listening for RPCs", (Object)this.mNodeAddress);
                NetworkAddressUtils.pingService((InetSocketAddress)this.mNodeAddress, (ServiceType)this.mServiceType, (AlluxioConfiguration)this.mConf, (UserState)this.mUserState);
                LOG.debug("Successfully connected to {}", (Object)this.mNodeAddress);
                return true;
            }
            catch (UnavailableException e) {
                LOG.debug("Failed to connect to {} on attempt #{}", (Object)this.mNodeAddress, (Object)retry.getAttemptCount());
            }
            catch (AlluxioStatusException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }
}

