/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.job.command;

import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.client.job.JobContext;
import alluxio.client.job.JobMasterClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.job.wire.JobInfo;
import alluxio.resource.CloseableResource;
import alluxio.security.user.UserState;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ListCommand
extends AbstractFileSystemCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ListCommand.class);

    public ListCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "ls";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)0);
    }

    public int run(CommandLine cl) {
        try (CloseableResource client = JobContext.create((AlluxioConfiguration)this.mFsContext.getClusterConf(), (UserState)this.mFsContext.getClientContext().getUserState()).acquireMasterClientResource();){
            List jobInfos = ((JobMasterClient)client.get()).listDetailed();
            for (JobInfo jobInfo : jobInfos) {
                System.out.println(String.format("%-15s %-10s %-10s", jobInfo.getId(), jobInfo.getName(), jobInfo.getStatus()));
            }
        }
        catch (Exception e) {
            LOG.error("Failed to list the jobs ", (Throwable)e);
            System.out.println("Failed to list the jobs");
            return -1;
        }
        return 0;
    }

    public String getUsage() {
        return "ls";
    }

    public String getDescription() {
        return "Prints the IDs of the most recent jobs, running and finished, in the history up to the capacity set in alluxio.job.master.job.capacity";
    }
}

