/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.job.command;

import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.client.job.JobContext;
import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.security.user.UserState;
import java.net.InetSocketAddress;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class LeaderCommand
extends AbstractFileSystemCommand {
    private static final Logger LOG = LoggerFactory.getLogger(LeaderCommand.class);

    public LeaderCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "leader";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)0);
    }

    public int run(CommandLine cl) {
        try {
            InetSocketAddress address = JobContext.create((AlluxioConfiguration)this.mFsContext.getClusterConf(), (UserState)this.mFsContext.getClientContext().getUserState()).getJobMasterAddress();
            System.out.println(address.getHostName());
        }
        catch (Exception e) {
            LOG.error("Failed to get the primary job master", (Throwable)e);
            System.out.println("Failed to get the primary job master.");
            return -1;
        }
        return 0;
    }

    public String getUsage() {
        return "leader";
    }

    public String getDescription() {
        return "Prints the hostname of the job master service leader.";
    }
}

