/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.job;

import alluxio.cli.AbstractShell;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.util.ConfigurationUtils;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class JobShell
extends AbstractShell {
    private static final Map<String, String[]> CMD_ALIAS = ImmutableMap.builder().build();

    public static void main(String[] argv) throws IOException {
        int ret;
        AlluxioConfiguration conf = Configuration.global();
        if (!ConfigurationUtils.masterHostConfigured((AlluxioConfiguration)conf) && argv.length > 0) {
            System.out.println(ConfigurationUtils.getMasterHostNotConfiguredMessage((String)"Alluxio job shell"));
            System.exit(1);
        }
        try (JobShell shell = new JobShell(conf);){
            ret = shell.run(argv);
        }
        System.exit(ret);
    }

    public JobShell(AlluxioConfiguration alluxioConf) {
        super(CMD_ALIAS, null, alluxioConf);
    }

    protected String getShellName() {
        return "job";
    }

    protected Map<String, Command> loadCommands() {
        return CommandUtils.loadCommands((String)JobShell.class.getPackage().getName(), (Class[])new Class[]{FileSystemContext.class}, (Object[])new Object[]{this.mCloser.register((Closeable)FileSystemContext.create((AlluxioConfiguration)this.mConfiguration))});
    }
}

