/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fsadmin.report;

import alluxio.client.metrics.MetricsMasterClient;
import alluxio.grpc.MetricValue;
import alluxio.metrics.MetricsSystem;
import alluxio.util.FormatUtils;
import com.google.common.math.DoubleMath;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;

public class MetricsCommand {
    private static final String BYTES_METRIC_IDENTIFIER = "Bytes";
    private static final String THROUGHPUT_METRIC_IDENTIFIER = "Throughput";
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("###,###.#####", new DecimalFormatSymbols(Locale.US));
    private static final String INFO_FORMAT = "%s  (Type: %s, Value: %s)%n";
    private final MetricsMasterClient mMetricsMasterClient;
    private final PrintStream mPrintStream;
    private Map<String, MetricValue> mMetricsMap;

    public MetricsCommand(MetricsMasterClient metricsMasterClient, PrintStream printStream) {
        this.mMetricsMasterClient = metricsMasterClient;
        this.mPrintStream = printStream;
    }

    public int run() throws IOException {
        this.mMetricsMap = this.mMetricsMasterClient.getMetrics();
        TreeSet<String> names = new TreeSet<String>(this.mMetricsMap.keySet());
        for (String name : names) {
            String strValue;
            if (!this.isAlluxioMetric(name)) continue;
            MetricValue metricValue = this.mMetricsMap.get(name);
            if (metricValue.hasStringValue()) {
                strValue = metricValue.getStringValue();
            } else {
                double doubleValue = metricValue.getDoubleValue();
                if (name.contains(BYTES_METRIC_IDENTIFIER)) {
                    strValue = FormatUtils.getSizeFromBytes((long)((long)doubleValue));
                    if (name.contains(THROUGHPUT_METRIC_IDENTIFIER)) {
                        strValue = strValue + "/MIN";
                    }
                } else {
                    strValue = DoubleMath.isMathematicalInteger((double)doubleValue) ? DECIMAL_FORMAT.format((long)doubleValue) : String.valueOf(doubleValue);
                }
            }
            this.mPrintStream.printf(INFO_FORMAT, name, metricValue.getMetricType(), strValue);
        }
        return 0;
    }

    private boolean isAlluxioMetric(String name) {
        for (MetricsSystem.InstanceType instance : MetricsSystem.InstanceType.values()) {
            if (!name.startsWith(instance.toString())) continue;
            return true;
        }
        return false;
    }
}

