/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fsadmin.pathconf;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fsadmin.command.AbstractFsAdminCommand;
import alluxio.cli.fsadmin.command.Context;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.AlluxioProperties;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.path.PathConfiguration;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.GetConfigurationPOptions;
import alluxio.wire.Configuration;
import alluxio.wire.Property;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public final class ShowCommand
extends AbstractFsAdminCommand {
    public static final String ALL_OPTION_NAME = "all";
    private static final Option ALL_OPTION = Option.builder().longOpt("all").required(false).hasArg(false).desc("Whether to show all path level configurations applicable to the path, including those set on ancestor paths").build();

    public ShowCommand(Context context, AlluxioConfiguration alluxioConf) {
        super(context);
    }

    public String getCommandName() {
        return "show";
    }

    public Options getOptions() {
        return new Options().addOption(ALL_OPTION);
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)1);
    }

    private String format(String key, Object value) {
        return key + "=" + value;
    }

    public int run(CommandLine cl) throws IOException {
        String targetPath = cl.getArgs()[0];
        Configuration configuration = this.mMetaConfigClient.getConfiguration(GetConfigurationPOptions.getDefaultInstance());
        if (cl.hasOption(ALL_OPTION_NAME)) {
            HashMap pathConfMap = new HashMap();
            configuration.getPathConf().forEach((path, conf) -> {
                AlluxioProperties properties = new AlluxioProperties();
                conf.forEach(property -> {
                    PropertyKey key = PropertyKey.fromString((String)property.getName());
                    properties.set(key, property.getValue());
                });
                pathConfMap.put(path, new InstancedConfiguration(properties));
            });
            PathConfiguration pathConf = PathConfiguration.create(pathConfMap);
            AlluxioURI targetUri = new AlluxioURI(targetPath);
            ArrayList<PropertyKey> propertyKeys = new ArrayList<PropertyKey>(pathConf.getPropertyKeys(targetUri));
            propertyKeys.sort(Comparator.comparing(PropertyKey::getName));
            propertyKeys.forEach(key -> pathConf.getConfiguration(targetUri, key).ifPresent(conf -> this.mPrintStream.println(this.format(key.getName(), conf.get(key)))));
        } else if (configuration.getPathConf().containsKey(targetPath)) {
            List properties = (List)configuration.getPathConf().get(targetPath);
            properties.sort(Comparator.comparing(Property::getName));
            properties.forEach(property -> this.mPrintStream.println(this.format(property.getName(), property.getValue())));
        }
        return 0;
    }

    public String getUsage() {
        return String.format("show [--%s] <path>%n\t--%s: %s", ALL_OPTION_NAME, ALL_OPTION_NAME, ALL_OPTION.getDescription());
    }

    @VisibleForTesting
    public static String description() {
        return "Shows path level configurations.";
    }

    public String getDescription() {
        return ShowCommand.description();
    }
}

