/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fsadmin.pathconf;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fsadmin.command.AbstractFsAdminCommand;
import alluxio.cli.fsadmin.command.Context;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.GrpcUtils;
import alluxio.grpc.Scope;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public final class AddCommand
extends AbstractFsAdminCommand {
    public static final String PROPERTY_OPTION_NAME = "property";
    private static final Option PROPERTY_OPTION = Option.builder().longOpt("property").required(false).hasArg(true).numberOfArgs(2).argName("key=value").valueSeparator('=').desc("property associated with the path").build();

    public AddCommand(Context context, AlluxioConfiguration alluxioConf) {
        super(context);
    }

    public String getCommandName() {
        return "add";
    }

    public Options getOptions() {
        return new Options().addOption(PROPERTY_OPTION);
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)1);
    }

    public int run(CommandLine cl) throws IOException {
        AlluxioURI path = new AlluxioURI(cl.getArgs()[0]);
        HashMap propertyMap = new HashMap();
        if (cl.hasOption(PROPERTY_OPTION_NAME)) {
            ImmutableMap properties = Maps.fromProperties((Properties)cl.getOptionProperties(PROPERTY_OPTION_NAME));
            for (Map.Entry property : properties.entrySet()) {
                PropertyKey key = PropertyKey.fromString((String)((String)property.getKey()));
                if (!GrpcUtils.contains((Scope)key.getScope(), (Scope)Scope.CLIENT)) {
                    throw new InvalidArgumentException(AddCommand.nonClientScopePropertyException(key));
                }
                propertyMap.put(key, property.getValue());
            }
        }
        this.mMetaConfigClient.setPathConfiguration(path, propertyMap);
        return 0;
    }

    public String getUsage() {
        return String.format("%s [--%s <key=value>] [--%s <key=value>] <path>%n\t--%s: %s", this.getCommandName(), PROPERTY_OPTION_NAME, PROPERTY_OPTION_NAME, PROPERTY_OPTION_NAME, PROPERTY_OPTION.getDescription());
    }

    @VisibleForTesting
    public static String description() {
        return "Adds properties to the path level configurations. Only client scope properties can be added.";
    }

    @VisibleForTesting
    public static String nonClientScopePropertyException(PropertyKey key) {
        return "Only properties with scope containing client scope can be set for path level configuration, but property key " + key + " has scope " + key.getScope().toString();
    }

    public String getDescription() {
        return AddCommand.description();
    }
}

