/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fsadmin.journal;

import alluxio.cli.Command;
import alluxio.cli.fsadmin.command.AbstractFsAdminCommand;
import alluxio.cli.fsadmin.command.Context;
import alluxio.cli.fsadmin.journal.QuorumElectCommand;
import alluxio.cli.fsadmin.journal.QuorumInfoCommand;
import alluxio.cli.fsadmin.journal.QuorumRemoveCommand;
import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.NetAddress;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;

public class QuorumCommand
extends AbstractFsAdminCommand {
    private static final Map<String, BiFunction<Context, AlluxioConfiguration, ? extends Command>> SUB_COMMANDS = new HashMap<String, BiFunction<Context, AlluxioConfiguration, ? extends Command>>();
    private Map<String, Command> mSubCommands = new HashMap<String, Command>();

    public QuorumCommand(Context context, AlluxioConfiguration alluxioConf) {
        super(context);
        SUB_COMMANDS.forEach((name, constructor) -> this.mSubCommands.put((String)name, (Command)constructor.apply(context, alluxioConf)));
    }

    @VisibleForTesting
    public static String description() {
        return "Manage embedded journal quorum configuration. See sub-commands' descriptions for more details.";
    }

    public Map<String, Command> getSubCommands() {
        return this.mSubCommands;
    }

    public String getCommandName() {
        return "quorum";
    }

    public String getUsage() {
        StringBuilder usage = new StringBuilder(this.getCommandName());
        for (String cmd : SUB_COMMANDS.keySet()) {
            usage.append(" [").append(cmd).append("]");
        }
        return usage.toString();
    }

    public String getDescription() {
        return QuorumCommand.description();
    }

    public static NetAddress stringToAddress(String serverAddress) throws InvalidArgumentException {
        int port;
        String hostName;
        try {
            hostName = serverAddress.substring(0, serverAddress.indexOf(":"));
            port = Integer.parseInt(serverAddress.substring(serverAddress.indexOf(":") + 1));
        }
        catch (Exception e) {
            throw new InvalidArgumentException(ExceptionMessage.INVALID_ADDRESS_VALUE.getMessage(new Object[0]));
        }
        return NetAddress.newBuilder().setHost(hostName).setRpcPort(port).build();
    }

    static {
        SUB_COMMANDS.put("info", QuorumInfoCommand::new);
        SUB_COMMANDS.put("remove", QuorumRemoveCommand::new);
        SUB_COMMANDS.put("elect", QuorumElectCommand::new);
    }
}

