/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fsadmin.journal;

import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fsadmin.command.AbstractFsAdminCommand;
import alluxio.cli.fsadmin.command.Context;
import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.util.CommonUtils;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.cli.CommandLine;

public class CheckpointCommand
extends AbstractFsAdminCommand {
    public CheckpointCommand(Context context, AlluxioConfiguration alluxioConf) {
        super(context);
    }

    public String getCommandName() {
        return "checkpoint";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(CommandLine cl) throws IOException {
        Thread thread = CommonUtils.createProgressThread((PrintStream)System.out);
        thread.start();
        try {
            String masterHostname = this.mMetaClient.checkpoint();
            this.mPrintStream.printf("Successfully took a checkpoint on master %s%n", masterHostname);
        }
        finally {
            thread.interrupt();
        }
        return 0;
    }

    public String getUsage() {
        return "checkpoint";
    }

    public String getDescription() {
        return "creates a checkpoint in the primary master journal system. This command is mainly used for debugging and to avoid master journal logs from growing unbounded. Checkpointing requires a pause in master metadata changes, so use this command sparingly to avoid interfering with other users of the system.";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)0);
    }
}

