/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fsadmin.doctor;

import alluxio.client.meta.MetaMasterClient;
import alluxio.grpc.ConfigStatus;
import alluxio.grpc.Scope;
import alluxio.wire.ConfigCheckReport;
import alluxio.wire.InconsistentProperty;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ConfigurationCommand {
    private final MetaMasterClient mMetaMasterClient;
    private final PrintStream mPrintStream;

    public ConfigurationCommand(MetaMasterClient metaMasterClient, PrintStream printStream) {
        this.mMetaMasterClient = metaMasterClient;
        this.mPrintStream = printStream;
    }

    public int run() throws IOException {
        Map warnings;
        ConfigCheckReport report = this.mMetaMasterClient.getConfigReport();
        ConfigStatus configStatus = report.getConfigStatus();
        if (configStatus == ConfigStatus.PASSED) {
            this.mPrintStream.println("No server-side configuration errors or warnings.");
            return 0;
        }
        Map errors = report.getConfigErrors();
        if (errors.size() != 0) {
            this.mPrintStream.println("Server-side configuration errors (those properties are required to be identical): ");
            this.printInconsistentProperties(errors);
        }
        if ((warnings = report.getConfigWarns()).size() != 0) {
            this.mPrintStream.println("\nServer-side configuration warnings (those properties are recommended to be identical): ");
            this.printInconsistentProperties(warnings);
        }
        return 0;
    }

    private void printInconsistentProperties(Map<Scope, List<InconsistentProperty>> inconsistentProperties) {
        for (List<InconsistentProperty> list : inconsistentProperties.values()) {
            for (InconsistentProperty prop : list) {
                this.mPrintStream.println("key: " + prop.getName());
                for (Map.Entry entry : prop.getValues().entrySet()) {
                    this.mPrintStream.println("    value: " + String.format("%s (%s)", ((Optional)entry.getKey()).orElse("no value set"), String.join((CharSequence)", ", (Iterable)entry.getValue())));
                }
            }
        }
    }
}

