/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fsadmin.command;

import alluxio.cli.CommandUtils;
import alluxio.cli.fsadmin.FileSystemAdminShellUtils;
import alluxio.cli.fsadmin.command.AbstractFsAdminCommand;
import alluxio.cli.fsadmin.command.Context;
import alluxio.cli.fsadmin.report.CapacityCommand;
import alluxio.cli.fsadmin.report.JobServiceMetricsCommand;
import alluxio.cli.fsadmin.report.MetricsCommand;
import alluxio.cli.fsadmin.report.SummaryCommand;
import alluxio.cli.fsadmin.report.UfsCommand;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.InvalidArgumentException;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public final class ReportCommand
extends AbstractFsAdminCommand {
    public static final String HELP_OPTION_NAME = "h";
    public static final String LIVE_OPTION_NAME = "live";
    public static final String LOST_OPTION_NAME = "lost";
    public static final String SPECIFIED_OPTION_NAME = "workers";
    private static final Option HELP_OPTION = Option.builder((String)"h").required(false).hasArg(false).desc("print help information.").build();
    private static final Option LIVE_OPTION = Option.builder((String)"live").required(false).hasArg(false).desc("show capacity information of live workers.").build();
    private static final Option LOST_OPTION = Option.builder((String)"lost").required(false).hasArg(false).desc("show capacity information of lost workers.").build();
    private static final Option SPECIFIED_OPTION = Option.builder((String)"workers").required(false).hasArg(true).desc("show capacity information of specified workers.").build();
    private AlluxioConfiguration mConf;

    public ReportCommand(Context context, AlluxioConfiguration alluxioConf) {
        super(context);
        this.mConf = alluxioConf;
    }

    public String getCommandName() {
        return "report";
    }

    public int run(CommandLine cl) throws IOException {
        String[] args = cl.getArgs();
        if (cl.hasOption(HELP_OPTION_NAME) && (args.length <= 0 || !args[0].equals("capacity"))) {
            System.out.println(this.getUsage());
            System.out.println(this.getDescription());
            return 0;
        }
        FileSystemAdminShellUtils.checkMasterClientService(this.mConf);
        Command command = Command.SUMMARY;
        if (args.length == 1) {
            switch (args[0]) {
                case "capacity": {
                    command = Command.CAPACITY;
                    break;
                }
                case "metrics": {
                    command = Command.METRICS;
                    break;
                }
                case "summary": {
                    command = Command.SUMMARY;
                    break;
                }
                case "ufs": {
                    command = Command.UFS;
                    break;
                }
                case "jobservice": {
                    command = Command.JOBSERVICE;
                    break;
                }
                default: {
                    System.out.println(this.getUsage());
                    System.out.println(this.getDescription());
                    throw new InvalidArgumentException("report category is invalid.");
                }
            }
        }
        if (!command.equals((Object)Command.CAPACITY) && cl.getOptions().length > 0) {
            throw new InvalidArgumentException(String.format("report %s does not support arguments: %s", command.toString().toLowerCase(), cl.getOptions()[0].getOpt()));
        }
        switch (command) {
            case CAPACITY: {
                CapacityCommand capacityCommand = new CapacityCommand(this.mBlockClient, this.mPrintStream);
                capacityCommand.run(cl);
                break;
            }
            case METRICS: {
                MetricsCommand metricsCommand = new MetricsCommand(this.mMetricsClient, this.mPrintStream);
                metricsCommand.run();
                break;
            }
            case SUMMARY: {
                SummaryCommand summaryCommand = new SummaryCommand(this.mMetaClient, this.mBlockClient, this.mConf.getString(PropertyKey.USER_DATE_FORMAT_PATTERN), this.mPrintStream);
                summaryCommand.run();
                break;
            }
            case UFS: {
                UfsCommand ufsCommand = new UfsCommand(this.mFsClient);
                ufsCommand.run();
                break;
            }
            case JOBSERVICE: {
                JobServiceMetricsCommand jobmetricsCommand = new JobServiceMetricsCommand(this.mJobMasterClient, this.mPrintStream, this.mConf.getString(PropertyKey.USER_DATE_FORMAT_PATTERN));
                jobmetricsCommand.run();
                break;
            }
        }
        return 0;
    }

    public Options getOptions() {
        return new Options().addOption(HELP_OPTION).addOption(LIVE_OPTION).addOption(LOST_OPTION).addOption(SPECIFIED_OPTION);
    }

    public String getUsage() {
        return ReportCommand.usage();
    }

    @VisibleForTesting
    public static String usage() {
        return "report [category] [category args]";
    }

    public String getDescription() {
        return ReportCommand.description();
    }

    @VisibleForTesting
    public static String description() {
        return "Report Alluxio running cluster information.\nWhere [category] is an optional argument. If no arguments are passed in, summary information will be printed out.\n[category] can be one of the following:\n    capacity         worker capacity information\n    metrics          metrics information\n    summary          cluster summary\n    ufs              under storage system information\n    jobservice       job service metrics information\n";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsNoMoreThan((alluxio.cli.Command)this, (CommandLine)cl, (int)1);
    }

    static enum Command {
        CAPACITY,
        METRICS,
        SUMMARY,
        UFS,
        JOBSERVICE;

    }
}

