/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fsadmin.command;

import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fsadmin.FileSystemAdminShellUtils;
import alluxio.cli.fsadmin.command.AbstractFsAdminCommand;
import alluxio.cli.fsadmin.command.Context;
import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.master.block.BlockId;
import alluxio.wire.BlockInfo;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class GetBlockInfoCommand
extends AbstractFsAdminCommand {
    private static final String HELP_OPTION_NAME = "h";
    private static final Option HELP_OPTION = Option.builder((String)"h").required(false).hasArg(false).desc("print help information.").build();
    private final AlluxioConfiguration mConf;

    public GetBlockInfoCommand(Context context, AlluxioConfiguration alluxioConf) {
        super(context);
        this.mConf = alluxioConf;
    }

    public String getCommandName() {
        return "getBlockInfo";
    }

    public int run(CommandLine cl) throws IOException {
        long blockId;
        if (cl.hasOption(HELP_OPTION_NAME)) {
            System.out.println(this.getUsage());
            System.out.println(this.getDescription());
            return 0;
        }
        FileSystemAdminShellUtils.checkMasterClientService(this.mConf);
        String arg = cl.getArgs()[0];
        try {
            blockId = Long.parseLong(arg);
        }
        catch (NumberFormatException e) {
            throw new InvalidArgumentException(arg + " is not a valid block id.");
        }
        BlockInfo info = null;
        try {
            info = this.mBlockClient.getBlockInfo(blockId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        long fileId = BlockId.getFileId((long)blockId);
        String path = null;
        try {
            path = this.mFsClient.getFilePath(fileId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (info != null) {
            System.out.println(info);
        } else {
            System.out.println("BlockMeta is not available for blockId: " + blockId);
        }
        if (path != null) {
            System.out.printf("This block belongs to file {id=%s, path=%s}%n", fileId, path);
        } else {
            System.out.printf("This block belongs to file {id=%s}%n", fileId);
        }
        return 0;
    }

    public String getUsage() {
        return "getBlockInfo [blockId]";
    }

    public String getDescription() {
        return "get the block information and file path of a specified block id.";
    }

    public Options getOptions() {
        return new Options().addOption(HELP_OPTION);
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)1);
    }
}

