/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fsadmin.command;

import alluxio.client.block.BlockMasterClient;
import alluxio.client.file.FileSystemMasterClient;
import alluxio.client.job.JobMasterClient;
import alluxio.client.journal.JournalMasterClient;
import alluxio.client.meta.MetaMasterClient;
import alluxio.client.meta.MetaMasterConfigClient;
import alluxio.client.metrics.MetricsMasterClient;
import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;

public final class Context
implements Closeable {
    private final FileSystemMasterClient mFsClient;
    private final BlockMasterClient mBlockClient;
    private final MetaMasterClient mMetaClient;
    private final MetaMasterConfigClient mMetaConfigClient;
    private final MetricsMasterClient mMetricsClient;
    private JournalMasterClient mMasterJournalMasterClient;
    private JournalMasterClient mJobMasterJournalMasterClient;
    private final JobMasterClient mJobMasterClient;
    private final PrintStream mPrintStream;
    private final Closer mCloser = Closer.create();

    public Context(FileSystemMasterClient fsClient, BlockMasterClient blockClient, MetaMasterClient metaClient, MetaMasterConfigClient metaConfigClient, MetricsMasterClient metricsClient, JournalMasterClient masterJournalMasterClient, JournalMasterClient jobMasterJournalMasterClient, JobMasterClient jobMasterClient, PrintStream printStream) {
        this.mFsClient = (FileSystemMasterClient)Preconditions.checkNotNull((Object)fsClient, (Object)"fsClient");
        this.mCloser.register((Closeable)this.mFsClient);
        this.mBlockClient = (BlockMasterClient)Preconditions.checkNotNull((Object)blockClient, (Object)"blockClient");
        this.mCloser.register((Closeable)this.mBlockClient);
        this.mMetaClient = (MetaMasterClient)Preconditions.checkNotNull((Object)metaClient, (Object)"metaClient");
        this.mCloser.register((Closeable)this.mMetaClient);
        this.mMetaConfigClient = (MetaMasterConfigClient)Preconditions.checkNotNull((Object)metaConfigClient, (Object)"metaConfigClient");
        this.mCloser.register((Closeable)this.mMetaConfigClient);
        this.mMetricsClient = (MetricsMasterClient)Preconditions.checkNotNull((Object)metricsClient, (Object)"metricsClient");
        this.mCloser.register((Closeable)this.mMetricsClient);
        this.mMasterJournalMasterClient = (JournalMasterClient)Preconditions.checkNotNull((Object)masterJournalMasterClient, (Object)"masterJournalMasterClient");
        this.mCloser.register((Closeable)this.mMasterJournalMasterClient);
        this.mJobMasterJournalMasterClient = (JournalMasterClient)Preconditions.checkNotNull((Object)jobMasterJournalMasterClient, (Object)"jobMasterJournalMasterClient");
        this.mCloser.register((Closeable)this.mJobMasterJournalMasterClient);
        this.mJobMasterClient = (JobMasterClient)Preconditions.checkNotNull((Object)jobMasterClient, (Object)"jobMasterClient");
        this.mCloser.register((Closeable)this.mJobMasterClient);
        this.mPrintStream = (PrintStream)Preconditions.checkNotNull((Object)printStream, (Object)"printStream");
        this.mCloser.register((Closeable)this.mPrintStream);
    }

    public FileSystemMasterClient getFsClient() {
        return this.mFsClient;
    }

    public BlockMasterClient getBlockClient() {
        return this.mBlockClient;
    }

    public MetaMasterClient getMetaClient() {
        return this.mMetaClient;
    }

    public MetaMasterConfigClient getMetaConfigClient() {
        return this.mMetaConfigClient;
    }

    public MetricsMasterClient getMetricsClient() {
        return this.mMetricsClient;
    }

    public JournalMasterClient getJournalMasterClientForMaster() {
        return this.mMasterJournalMasterClient;
    }

    public JournalMasterClient getJournalMasterClientForJobMaster() {
        return this.mJobMasterJournalMasterClient;
    }

    public JobMasterClient getJobMasterClient() {
        return this.mJobMasterClient;
    }

    public PrintStream getPrintStream() {
        return this.mPrintStream;
    }

    @Override
    public void close() throws IOException {
        this.mCloser.close();
    }
}

