/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.MountPOptions;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

@ThreadSafe
public final class UpdateMountCommand
extends AbstractFileSystemCommand {
    private static final Option READONLY_OPTION = Option.builder().longOpt("readonly").required(false).hasArg(false).desc("mount point is readonly in Alluxio").build();
    private static final Option SHARED_OPTION = Option.builder().longOpt("shared").required(false).hasArg(false).desc("mount point is shared").build();
    private static final Option OPTION_OPTION = Option.builder().longOpt("option").required(false).hasArg(true).numberOfArgs(2).argName("key=value").valueSeparator('=').desc("options for this mount point. For security reasons, no options from existing mount point will be inherited.").build();

    public UpdateMountCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "updateMount";
    }

    public Options getOptions() {
        return new Options().addOption(READONLY_OPTION).addOption(SHARED_OPTION).addOption(OPTION_OPTION);
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        String[] args = cl.getArgs();
        AlluxioURI alluxioPath = new AlluxioURI(args[0]);
        MountPOptions.Builder optionsBuilder = MountPOptions.newBuilder();
        if (cl.hasOption(READONLY_OPTION.getLongOpt())) {
            optionsBuilder.setReadOnly(true);
        }
        if (cl.hasOption(SHARED_OPTION.getLongOpt())) {
            optionsBuilder.setShared(true);
        }
        if (cl.hasOption(OPTION_OPTION.getLongOpt())) {
            Properties properties = cl.getOptionProperties(OPTION_OPTION.getLongOpt());
            optionsBuilder.putAllProperties((Map)Maps.fromProperties((Properties)properties));
        }
        this.mFileSystem.updateMount(alluxioPath, optionsBuilder.build());
        System.out.println("Updated mount point options at " + alluxioPath);
        return 0;
    }

    public String getUsage() {
        return "updateMount [--readonly] [--shared] [--option <key=val>] <alluxioPath>";
    }

    public String getDescription() {
        return "Updates options for a mount point while keeping the Alluxio metadata under the path.";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        if (cl.getArgs().length != 1) {
            throw new InvalidArgumentException("Command updateMount takes 1 argument, not " + cl.getArgs().length);
        }
    }
}

