/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.cli.fs.command.FileSystemCommandUtils;
import alluxio.client.file.FileSystemContext;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import java.io.IOException;
import java.util.Collections;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class UnpinCommand
extends AbstractFileSystemCommand {
    public UnpinCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "unpin";
    }

    @Override
    protected void runPlainPath(AlluxioURI path, CommandLine cl) throws AlluxioException, IOException {
        FileSystemCommandUtils.setPinned(this.mFileSystem, path, false, Collections.emptyList());
        System.out.println("File '" + path + "' was successfully unpinned.");
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        String[] args = cl.getArgs();
        AlluxioURI path = new AlluxioURI(args[0]);
        this.runWildCardCmd(path, cl);
        return 0;
    }

    public String getUsage() {
        return "unpin <path>";
    }

    public String getDescription() {
        return "Unpins the given file or folder from memory (works recursively for a directory).";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsNoLessThan((Command)this, (CommandLine)cl, (int)1);
    }
}

