/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class TouchCommand
extends AbstractFileSystemCommand {
    public TouchCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "touch";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)1);
    }

    @Override
    protected void runPlainPath(AlluxioURI inputPath, CommandLine cl) throws AlluxioException, IOException {
        this.mFileSystem.createFile(inputPath).close();
        System.out.println(inputPath + " has been created");
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        String[] args = cl.getArgs();
        AlluxioURI inputPath = new AlluxioURI(args[0]);
        this.runWildCardCmd(inputPath, cl);
        return 0;
    }

    public String getUsage() {
        return "touch <path>";
    }

    public String getDescription() {
        return "Creates a 0 byte file. The file will be written to the under file system.";
    }
}

