/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.FileSystemShellUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.cli.fs.command.FileSystemCommandUtils;
import alluxio.client.file.FileSystemContext;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.TtlAction;
import alluxio.util.CommonUtils;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

@ThreadSafe
public final class SetTtlCommand
extends AbstractFileSystemCommand {
    private static final String TTL_ACTION = "action";
    private static final Option TTL_ACTION_OPTION = Option.builder().longOpt("action").required(false).numberOfArgs(1).desc("Action to take after TTL expiry. Delete (default) or free the target").build();
    private TtlAction mAction = TtlAction.DELETE;
    private long mTtlMs;

    public SetTtlCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "setTtl";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)2);
        String operation = cl.getOptionValue(TTL_ACTION);
        if (operation != null) {
            try {
                this.mAction = TtlAction.valueOf((String)operation.toUpperCase());
            }
            catch (Exception e) {
                throw new InvalidArgumentException(String.format("TTL action should be %s OR %s, not %s", TtlAction.DELETE, TtlAction.FREE, operation));
            }
        }
    }

    public Options getOptions() {
        return new Options().addOption(TTL_ACTION_OPTION);
    }

    @Override
    protected void runPlainPath(AlluxioURI path, CommandLine cl) throws AlluxioException, IOException {
        FileSystemCommandUtils.setTtl(this.mFileSystem, path, this.mTtlMs, this.mAction);
        System.out.println("TTL of path '" + path + "' was successfully set to " + this.mTtlMs + " milliseconds, with expiry action set to " + this.mAction);
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        String[] args = cl.getArgs();
        String ttl = CommonUtils.stripLeadingAndTrailingQuotes((String)args[1]);
        this.mTtlMs = FileSystemShellUtils.getMs(ttl);
        AlluxioURI path = new AlluxioURI(args[0]);
        this.runWildCardCmd(path, cl);
        return 0;
    }

    public String getUsage() {
        return "setTtl [--action delete|free] <path> <time to live>";
    }

    public String getDescription() {
        return "Sets a new TTL value for the file at path, performing an action, delete(default)/free after TTL expiry. The TTL to set can be in one of the unit: ms, millisecond, s, second, m, min, minute, h, hour, d, day, default to ms";
    }
}

