/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.SetAttributePOptions;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

@ThreadSafe
public final class SetReplicationCommand
extends AbstractFileSystemCommand {
    private static final Option MAX_OPTION = Option.builder().longOpt("max").required(false).numberOfArgs(1).desc("the maximum number of replicas").build();
    private static final Option MIN_OPTION = Option.builder().longOpt("min").required(false).numberOfArgs(1).desc("the minimum number of replicas").build();
    private static final Option RECURSIVE_OPTION = Option.builder((String)"R").required(false).hasArg(false).desc("set replication recursively").build();

    public SetReplicationCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "setReplication";
    }

    public Options getOptions() {
        return new Options().addOption(RECURSIVE_OPTION).addOption(MAX_OPTION).addOption(MIN_OPTION);
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)1);
    }

    private void setReplication(AlluxioURI path, Integer replicationMax, Integer replicationMin, boolean recursive) throws AlluxioException, IOException {
        SetAttributePOptions.Builder optionsBuilder = SetAttributePOptions.newBuilder().setRecursive(recursive);
        String message = "Changed the replication level of " + path + "\n";
        if (replicationMax != null) {
            optionsBuilder.setReplicationMax(replicationMax.intValue());
            message = message + "replicationMax was set to " + replicationMax + "\n";
        }
        if (replicationMin != null) {
            optionsBuilder.setReplicationMin(replicationMin.intValue());
            message = message + "replicationMin was set to " + replicationMin + "\n";
        }
        this.mFileSystem.setAttribute(path, optionsBuilder.build());
        System.out.println(message);
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        String[] args = cl.getArgs();
        AlluxioURI path = new AlluxioURI(args[0]);
        Integer replicationMax = cl.hasOption(MAX_OPTION.getLongOpt()) ? Integer.valueOf(cl.getOptionValue(MAX_OPTION.getLongOpt())) : null;
        Integer replicationMin = cl.hasOption(MIN_OPTION.getLongOpt()) ? Integer.valueOf(cl.getOptionValue(MIN_OPTION.getLongOpt())) : null;
        boolean recursive = cl.hasOption(RECURSIVE_OPTION.getOpt());
        if (replicationMax == null && replicationMin == null) {
            throw new IOException("At least one option of '--max' or '--min' must be specified");
        }
        if (replicationMax != null && replicationMin != null && replicationMax >= 0 && replicationMax < replicationMin) {
            throw new IOException("Invalid values for '--max' and '--min' options");
        }
        this.setReplication(path, replicationMax, replicationMin, recursive);
        return 0;
    }

    public String getUsage() {
        return "setReplication [-R] [--max <num> | --min <num>] <path>";
    }

    public String getDescription() {
        return "Sets the minimum/maximum number of replicas for the file or directory at given path. Specify '-1' as the argument of '--max' option to indicate no limit of the maximum number of replicas. If 'path' is a directory and '-R' is specified, it will recursively set all files in this directory.";
    }
}

