/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.exception.AlluxioException;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.DeletePOptions;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

@ThreadSafe
public final class RmCommand
extends AbstractFileSystemCommand {
    private static final Option RECURSIVE_OPTION = Option.builder((String)"R").longOpt("recursive").required(false).hasArg(false).desc("delete files and subdirectories recursively").build();
    private static final Option RECURSIVE_ALIAS_OPTION = Option.builder((String)"r").required(false).hasArg(false).desc("copy files in subdirectories recursively").build();
    private static final String REMOVE_UNCHECKED_OPTION_CHAR = "U";
    private static final Option REMOVE_UNCHECKED_OPTION = Option.builder((String)"U").required(false).hasArg(false).desc("remove directories without checking UFS contents are in sync").build();
    private static final Option REMOVE_ALLUXIO_ONLY = Option.builder().longOpt("alluxioOnly").required(false).hasArg(false).desc("remove data and metadata from Alluxio space only").build();
    private static final Option DELETE_MOUNT_POINT = Option.builder((String)"m").longOpt("deleteMountPoint").required(false).hasArg(false).desc("remove mount points in the directory").build();

    public RmCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "rm";
    }

    public Options getOptions() {
        return new Options().addOption(RECURSIVE_OPTION).addOption(RECURSIVE_ALIAS_OPTION).addOption(REMOVE_UNCHECKED_OPTION).addOption(REMOVE_ALLUXIO_ONLY).addOption(DELETE_MOUNT_POINT);
    }

    @Override
    protected void runPlainPath(AlluxioURI path, CommandLine cl) throws AlluxioException, IOException {
        boolean recursive;
        boolean bl = recursive = cl.hasOption(RECURSIVE_OPTION.getOpt()) || cl.hasOption(RECURSIVE_ALIAS_OPTION.getOpt());
        if (!this.mFileSystem.exists(path)) {
            throw new FileDoesNotExistException(ExceptionMessage.PATH_DOES_NOT_EXIST.getMessage(new Object[]{path}));
        }
        if (!recursive && this.mFileSystem.getStatus(path).isFolder()) {
            throw new IOException(path.getPath() + " is a directory, to remove it, please use \"rm -R/-r/--recursive <path>\"");
        }
        boolean isAlluxioOnly = cl.hasOption(REMOVE_ALLUXIO_ONLY.getLongOpt());
        boolean isDeleteMountPoint = cl.hasOption(DELETE_MOUNT_POINT.getLongOpt());
        DeletePOptions options = DeletePOptions.newBuilder().setRecursive(recursive).setAlluxioOnly(isAlluxioOnly).setDeleteMountPoint(isDeleteMountPoint).setUnchecked(cl.hasOption(REMOVE_UNCHECKED_OPTION_CHAR)).build();
        this.mFileSystem.delete(path, options);
        if (!isAlluxioOnly) {
            System.out.println(path + " has been removed");
        } else {
            System.out.println(path + " has been removed only from Alluxio space");
        }
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        String[] args = cl.getArgs();
        AlluxioURI path = new AlluxioURI(args[0]);
        this.runWildCardCmd(path, cl);
        return 0;
    }

    public String getUsage() {
        return "rm [-R/-r/--recursive] [-U] [--alluxioOnly] [-m/--deleteMountPoint] <path>";
    }

    public String getDescription() {
        return "Removes the specified file. Specify -R/-r/--recursive to remove file or directory recursively. Specify -U to remove directories without checking  UFS contents are in sync. Specify --alluxioOnly to remove data and metadata from alluxio space only. Specify -m/--deleteMountPoint to allow removing mount points, otherwise the rm will fail if the directory contains mount points.";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsNoLessThan((Command)this, (CommandLine)cl, (int)1);
    }
}

