/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.FileSystemShellUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.FileSystemUtils;
import alluxio.client.file.URIStatus;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.util.ThreadFactoryUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class PersistCommand
extends AbstractFileSystemCommand {
    private static final Logger LOG = LoggerFactory.getLogger(PersistCommand.class);
    private static final int DEFAULT_PARALLELISM = 4;
    private static final Option PARALLELISM_OPTION = Option.builder((String)"p").longOpt("parallelism").argName("# concurrent operations").numberOfArgs(1).desc("Number of concurrent persist operations, default: 4").required(false).build();
    private static final int DEFAULT_TIMEOUT = 1200000;
    private static final Option TIMEOUT_OPTION = Option.builder((String)"t").longOpt("timeout").argName("timeout in milliseconds").numberOfArgs(1).desc("Time in milliseconds for a single file persist to time out; default:1200000").required(false).build();
    private static final int DEFAULT_WAIT_TIME = 0;
    private static final Option WAIT_OPTION = Option.builder((String)"w").longOpt("wait").argName("the initial persistence wait time").numberOfArgs(1).desc("The time to wait before persisting. default: 0").required(false).build();

    public PersistCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "persist";
    }

    public Options getOptions() {
        return new Options().addOption(PARALLELISM_OPTION).addOption(TIMEOUT_OPTION).addOption(WAIT_OPTION);
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsNoLessThan((Command)this, (CommandLine)cl, (int)1);
    }

    public String getUsage() {
        return "persist [-p|--parallelism <#>] [-t|--timeout <milliseconds>] [-w|--wait <milliseconds>] <path> [<path> ...]";
    }

    public String getDescription() {
        return "Persists files or directories currently stored only in Alluxio to the UnderFileSystem.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(CommandLine cl) throws AlluxioException, IOException {
        int parallelism = FileSystemShellUtils.getIntArg(cl, PARALLELISM_OPTION, 4);
        int timeoutMs = (int)FileSystemShellUtils.getMsArg(cl, TIMEOUT_OPTION, 1200000L);
        long persistenceWaitTimeMs = FileSystemShellUtils.getMsArg(cl, WAIT_OPTION, 0L);
        if (persistenceWaitTimeMs > (long)timeoutMs && timeoutMs != -1 || persistenceWaitTimeMs < 0L) {
            System.out.println("Persistence initial wait time should be smaller than persist timeout and bigger than zero");
            return -1;
        }
        String[] args = cl.getArgs();
        ArrayList<AlluxioURI> candidateUris = new ArrayList<AlluxioURI>();
        for (String path : args) {
            candidateUris.addAll(FileSystemShellUtils.getAlluxioURIs(this.mFileSystem, new AlluxioURI(path)));
        }
        ConcurrentLinkedQueue<AlluxioURI> toPersist = new ConcurrentLinkedQueue<AlluxioURI>();
        for (AlluxioURI uri : candidateUris) {
            this.queueNonPersistedRecursive(this.mFileSystem.getStatus(uri), toPersist);
        }
        int totalFiles = toPersist.size();
        System.out.println("Found " + totalFiles + " files to persist.");
        if (totalFiles == 0) {
            return 0;
        }
        parallelism = Math.min(totalFiles, parallelism);
        ExecutorService service = Executors.newFixedThreadPool(parallelism, ThreadFactoryUtils.build((String)"persist-cli-%d", (boolean)true));
        Object progressLock = new Object();
        AtomicInteger completedFiles = new AtomicInteger(0);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(parallelism);
        for (int i = 0; i < parallelism; ++i) {
            futures.add(service.submit(new PersistCallable(toPersist, totalFiles, completedFiles, progressLock, persistenceWaitTimeMs, timeoutMs)));
        }
        try {
            for (Future future : futures) {
                future.get();
            }
        }
        catch (ExecutionException e) {
            System.out.println("Fatal error: " + e);
            int n = -1;
            return n;
        }
        catch (InterruptedException e) {
            System.out.println("Persist interrupted, exiting.");
            int n = -1;
            return n;
        }
        finally {
            service.shutdownNow();
        }
        return 0;
    }

    private void queueNonPersistedRecursive(URIStatus status, Queue<AlluxioURI> toPersist) throws AlluxioException, IOException {
        AlluxioURI uri = new AlluxioURI(status.getPath());
        if (status.isFolder()) {
            List statuses = this.mFileSystem.listStatus(uri);
            for (URIStatus s : statuses) {
                this.queueNonPersistedRecursive(s, toPersist);
            }
        } else if (!status.isPersisted()) {
            toPersist.add(uri);
        }
    }

    private class PersistCallable
    implements Callable<Void> {
        private final Queue<AlluxioURI> mFilesToPersist;
        private final int mTotalFiles;
        private final Object mProgressLock;
        private final AtomicInteger mCompletedFiles;
        private final long mPersistenceWaitTime;
        private final int mTimeoutMs;

        PersistCallable(Queue<AlluxioURI> toPersist, int totalFiles, AtomicInteger completedFiles, Object progressLock, long persistenceWaitTime, int timeoutMs) {
            this.mFilesToPersist = toPersist;
            this.mTotalFiles = totalFiles;
            this.mProgressLock = progressLock;
            this.mCompletedFiles = completedFiles;
            this.mPersistenceWaitTime = persistenceWaitTime;
            this.mTimeoutMs = timeoutMs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            AlluxioURI toPersist = this.mFilesToPersist.poll();
            while (toPersist != null) {
                try {
                    FileSystemUtils.persistAndWait((FileSystem)PersistCommand.this.mFileSystem, (AlluxioURI)toPersist, (long)this.mPersistenceWaitTime, (int)this.mTimeoutMs);
                    Object object = this.mProgressLock;
                    synchronized (object) {
                        String progress = "(" + this.mCompletedFiles.incrementAndGet() + "/" + this.mTotalFiles + ")";
                        System.out.println(progress + " Successfully persisted file: " + toPersist);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    LOG.warn("Interrupted while waiting for persistence ", (Throwable)e);
                    throw e;
                }
                catch (TimeoutException e) {
                    String timeoutMsg = String.format("Timed out waiting for file to be persisted: %s", toPersist);
                    System.out.println(timeoutMsg);
                    LOG.error(timeoutMsg, (Throwable)e);
                }
                catch (Exception e) {
                    System.out.println("Failed to persist file " + toPersist);
                    LOG.error("Failed to persist file {}", (Object)toPersist, (Object)e);
                }
                toPersist = this.mFilesToPersist.poll();
            }
            return null;
        }
    }
}

