/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public class NeedsSyncCommand
extends AbstractFileSystemCommand {
    public NeedsSyncCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "needsSync";
    }

    @Override
    protected void runPlainPath(AlluxioURI plainPath, CommandLine cl) throws AlluxioException, IOException {
        this.needsSync(plainPath);
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        String[] args = cl.getArgs();
        AlluxioURI path = new AlluxioURI(args[0]);
        this.runWildCardCmd(path, cl);
        return 0;
    }

    private void needsSync(AlluxioURI path) throws IOException {
        try {
            this.mFileSystem.needsSync(path);
        }
        catch (AlluxioException e) {
            throw new IOException(e.getMessage());
        }
    }

    public String getUsage() {
        return "needsSync <path>";
    }

    public String getDescription() {
        return "Marks the path in Alluxio as needing synchronization with the under file system. The next time the path or any of its children are accessed a metadata synchronization will be performed.";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)1);
    }
}

