/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class MvCommand
extends AbstractFileSystemCommand {
    public MvCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "mv";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)2);
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        String[] args = cl.getArgs();
        AlluxioURI srcPath = new AlluxioURI(args[0]);
        AlluxioURI dstPath = new AlluxioURI(args[1]);
        this.mFileSystem.rename(srcPath, dstPath);
        System.out.println("Renamed " + srcPath + " to " + dstPath);
        return 0;
    }

    public String getUsage() {
        return "mv <src> <dst>";
    }

    public String getDescription() {
        return "Renames a file or directory.";
    }
}

