/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.cli.fsadmin.report.UfsCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.MountPOptions;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

@ThreadSafe
public final class MountCommand
extends AbstractFileSystemCommand {
    private static final Option READONLY_OPTION = Option.builder().longOpt("readonly").required(false).hasArg(false).desc("mount point is readonly in Alluxio").build();
    private static final Option SHARED_OPTION = Option.builder().longOpt("shared").required(false).hasArg(false).desc("mount point is shared").build();
    private static final Option OPTION_OPTION = Option.builder().longOpt("option").required(false).hasArg(true).numberOfArgs(2).argName("key=value").valueSeparator('=').desc("options associated with this mount point").build();

    public MountCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "mount";
    }

    public Options getOptions() {
        return new Options().addOption(READONLY_OPTION).addOption(SHARED_OPTION).addOption(OPTION_OPTION);
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        String[] args = cl.getArgs();
        if (args.length == 0) {
            Map mountTable = this.mFileSystem.getMountTable();
            UfsCommand.printMountInfo(mountTable);
            return 0;
        }
        AlluxioURI alluxioPath = new AlluxioURI(args[0]);
        AlluxioURI ufsPath = new AlluxioURI(args[1]);
        MountPOptions.Builder optionsBuilder = MountPOptions.newBuilder();
        if (cl.hasOption(READONLY_OPTION.getLongOpt())) {
            optionsBuilder.setReadOnly(true);
        }
        if (cl.hasOption(SHARED_OPTION.getLongOpt())) {
            optionsBuilder.setShared(true);
        }
        if (cl.hasOption(OPTION_OPTION.getLongOpt())) {
            Properties properties = cl.getOptionProperties(OPTION_OPTION.getLongOpt());
            optionsBuilder.putAllProperties((Map)Maps.fromProperties((Properties)properties));
        }
        this.mFileSystem.mount(alluxioPath, ufsPath, optionsBuilder.build());
        System.out.println("Mounted " + ufsPath + " at " + alluxioPath);
        return 0;
    }

    public String getUsage() {
        return "mount [--readonly] [--shared] [--option <key=val>] <alluxioPath> <ufsURI>";
    }

    public String getDescription() {
        return "Mounts a UFS path onto an Alluxio path.";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        if (cl.getArgs().length != 2 && cl.getArgs().length != 0) {
            throw new InvalidArgumentException("Command mount takes 0 or 2 arguments, not " + cl.getArgs().length);
        }
    }
}

