/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.URIStatus;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.FreePOptions;
import alluxio.util.CommonUtils;
import alluxio.util.WaitForOptions;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

@ThreadSafe
public final class FreeCommand
extends AbstractFileSystemCommand {
    private static final Option FORCE_OPTION = Option.builder((String)"f").required(false).hasArg(false).desc("force to free files even pinned").build();

    public FreeCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public Options getOptions() {
        return new Options().addOption(FORCE_OPTION);
    }

    public String getCommandName() {
        return "free";
    }

    @Override
    protected void runPlainPath(AlluxioURI path, CommandLine cl) throws AlluxioException, IOException {
        int interval = Math.toIntExact(this.mFsContext.getPathConf(path).getMs(PropertyKey.WORKER_BLOCK_HEARTBEAT_INTERVAL_MS));
        FreePOptions options = FreePOptions.newBuilder().setRecursive(true).setForced(cl.hasOption("f")).build();
        this.mFileSystem.free(path, options);
        try {
            CommonUtils.waitFor((String)"file to be freed. Another user may be loading it.", () -> {
                try {
                    URIStatus fileStatus = this.mFileSystem.getStatus(path);
                    if (fileStatus.getLength() == 0L && !fileStatus.isFolder()) {
                        return true;
                    }
                    if (fileStatus.getInAlluxioPercentage() > 0) {
                        this.mFileSystem.free(path, options);
                        return fileStatus.getInAlluxioPercentage() == 0;
                    }
                    return true;
                }
                catch (Exception e) {
                    Throwables.propagateIfPossible((Throwable)e);
                    throw new RuntimeException(e);
                }
            }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(10 * Math.toIntExact(interval)).setInterval(interval));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
        System.out.println(path + " was successfully freed from Alluxio space.");
    }

    public String getUsage() {
        return "free [-f] <path>";
    }

    public String getDescription() {
        return "Frees the space occupied by a file or a directory in Alluxio. Specify -f to force freeing pinned files in the directory.";
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        String[] args = cl.getArgs();
        AlluxioURI path = new AlluxioURI(args[0]);
        this.runWildCardCmd(path, cl);
        return 0;
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsNoLessThan((Command)this, (CommandLine)cl, (int)1);
    }
}

