/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.cli.fs.command.AbstractDistributedJobCommand;
import alluxio.cli.fs.command.DistributedCpCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.DeletePOptions;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;

public class DistributedMvCommand
extends AbstractDistributedJobCommand {
    private final DistributedCpCommand mCpCommand;

    public DistributedMvCommand(FileSystemContext fsContext) {
        super(fsContext);
        this.mCpCommand = new DistributedCpCommand(fsContext);
    }

    public String getCommandName() {
        return "distributedMv";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        this.mCpCommand.validateArgs(cl);
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        try {
            this.mCpCommand.run(cl);
        }
        catch (AlluxioException | IOException e) {
            System.out.println("Copy operation portion of Move failed. If the error below is intermittent, you can rerun this by deleting the destination first.");
            throw e;
        }
        String[] args = cl.getArgs();
        AlluxioURI srcPath = new AlluxioURI(args[0]);
        System.out.println("Deleting " + srcPath);
        this.mFileSystem.delete(srcPath, DeletePOptions.newBuilder().setUnchecked(true).setRecursive(true).build());
        return 0;
    }

    public String getUsage() {
        return "distributedMv <src> <dst>";
    }

    public String getDescription() {
        return "Moves a file or directory in parallel at file level";
    }
}

