/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractDistributedJobCommand;
import alluxio.cli.fs.command.DistributedLoadUtils;
import alluxio.client.file.FileSystemContext;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

@ThreadSafe
public final class DistributedLoadCommand
extends AbstractDistributedJobCommand {
    public DistributedLoadCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "distributedLoad";
    }

    public Options getOptions() {
        return DistributedLoadUtils.getDistLoadFileSemanticsOptions();
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)1);
    }

    public String getUsage() {
        return "distributedLoad " + DistributedLoadUtils.getDistLoadFileSemanticsUsage() + "<path>";
    }

    public String getDescription() {
        return "Loads a file or all files in a directory into Alluxio space.";
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        String[] args = cl.getArgs();
        return DistributedLoadUtils.distributedLoad(this, cl, args[0]);
    }

    public void close() throws IOException {
        this.mClient.close();
    }
}

