/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.cli.fs.command.CpCommand;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import java.io.File;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class CopyFromLocalCommand
extends AbstractFileSystemCommand {
    private static final Logger LOG = LoggerFactory.getLogger(CopyFromLocalCommand.class);
    private final CpCommand mCpCommand;

    public CopyFromLocalCommand(FileSystemContext fsContext) {
        super(fsContext);
        FileSystemContext updatedCtx;
        InstancedConfiguration conf = new InstancedConfiguration(fsContext.getClusterConf().copyProperties());
        conf.set(PropertyKey.USER_BLOCK_WRITE_LOCATION_POLICY, conf.get(PropertyKey.USER_FILE_COPYFROMLOCAL_BLOCK_LOCATION_POLICY));
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("copyFromLocal block write location policy is %s from property %s", conf.get(PropertyKey.USER_BLOCK_WRITE_LOCATION_POLICY), PropertyKey.USER_FILE_COPYFROMLOCAL_BLOCK_LOCATION_POLICY.getName()));
        }
        this.mFsContext = updatedCtx = FileSystemContext.create((AlluxioConfiguration)conf);
        this.mFileSystem = FileSystem.Factory.create((FileSystemContext)updatedCtx);
        this.mCpCommand = new CpCommand(updatedCtx);
    }

    public void close() throws IOException {
        this.mFileSystem.close();
    }

    public String getCommandName() {
        return "copyFromLocal";
    }

    public Options getOptions() {
        return new Options().addOption(CpCommand.THREAD_OPTION).addOption(CpCommand.BUFFER_SIZE_OPTION);
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        this.mCpCommand.validateArgs(cl);
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        String[] args = cl.getArgs();
        String srcPath = args[0];
        cl.getArgList().set(0, "file://" + new File(srcPath).getAbsolutePath());
        this.mCpCommand.run(cl);
        return 0;
    }

    public String getUsage() {
        return "copyFromLocal [--thread <num>] [--buffersize <bytes>] <src> <remoteDst>";
    }

    public String getDescription() {
        return "Copies a file or a directory from local filesystem to Alluxio filesystem in parallel at file level.";
    }
}

