/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.URIStatus;
import alluxio.exception.AlluxioException;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.status.InvalidArgumentException;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class CatCommand
extends AbstractFileSystemCommand {
    public CatCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "cat";
    }

    @Override
    protected void runPlainPath(AlluxioURI path, CommandLine cl) throws AlluxioException, IOException {
        URIStatus status = this.mFileSystem.getStatus(path);
        if (status.isFolder()) {
            throw new FileDoesNotExistException(ExceptionMessage.PATH_MUST_BE_FILE.getMessage(new Object[]{path}));
        }
        byte[] buf = new byte[0x100000];
        try (FileInStream is = this.mFileSystem.openFile(path);){
            int read = is.read(buf);
            while (read != -1) {
                System.out.write(buf, 0, read);
                read = is.read(buf);
            }
        }
    }

    public String getUsage() {
        return "cat <path>";
    }

    public String getDescription() {
        return "Prints the file's contents to the console.";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsNoLessThan((Command)this, (CommandLine)cl, (int)1);
    }

    public int run(CommandLine cl) throws IOException {
        String[] args = cl.getArgs();
        this.runWildCardCmd(new AlluxioURI(args[0]), cl);
        return 0;
    }
}

