/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.docgen;

import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.util.io.PathUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ConfigurationDocGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationDocGenerator.class);
    private static final String CSV_FILE_DIR = "docs/_data/table/";
    private static final String YML_FILE_DIR = "docs/_data/table/en/";
    public static final String CSV_FILE_HEADER = "propertyName,defaultValue";

    private ConfigurationDocGenerator() {
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public static void writeCSVFile(Collection<? extends PropertyKey> defaultKeys, String filePath) throws IOException {
        if (defaultKeys.size() == 0) {
            return;
        }
        Closer closer = Closer.create();
        String[] fileNames = new String[]{"user-configuration.csv", "master-configuration.csv", "worker-configuration.csv", "security-configuration.csv", "common-configuration.csv", "cluster-management-configuration.csv"};
        try {
            FileWriter fileWriter;
            void var8_11;
            HashMap<String, FileWriter> fileWriterMap = new HashMap<String, FileWriter>();
            String[] stringArray = fileNames;
            int n = stringArray.length;
            boolean bl = false;
            while (var8_11 < n) {
                String fileName = stringArray[var8_11];
                fileWriter = new FileWriter(PathUtils.concatPath((Object)filePath, (Object)fileName));
                fileWriter.append("propertyName,defaultValue\n");
                String key = fileName.substring(0, fileName.indexOf("configuration") - 1);
                fileWriterMap.put(key, fileWriter);
                closer.register((Closeable)fileWriter);
                ++var8_11;
            }
            ArrayList<? extends PropertyKey> dfkeys = new ArrayList<PropertyKey>(defaultKeys);
            Collections.sort(dfkeys);
            for (PropertyKey propertyKey : dfkeys) {
                String pKey = propertyKey.toString();
                String defaultDescription = propertyKey.getDefaultSupplier().get() == null ? "" : propertyKey.getDefaultSupplier().getDescription();
                defaultDescription = String.format("\"%s\"", defaultDescription);
                String keyValueStr = pKey + "," + defaultDescription + "\n";
                fileWriter = pKey.startsWith("alluxio.user.") ? (FileWriter)fileWriterMap.get("user") : (pKey.startsWith("alluxio.master.") ? (FileWriter)fileWriterMap.get("master") : (pKey.startsWith("alluxio.worker.") ? (FileWriter)fileWriterMap.get("worker") : (pKey.startsWith("alluxio.security.") ? (FileWriter)fileWriterMap.get("security") : (pKey.startsWith("alluxio.integration") ? (FileWriter)fileWriterMap.get("cluster-management") : (FileWriter)fileWriterMap.get("common")))));
                fileWriter.append(keyValueStr);
            }
            LOG.info("Property Key CSV files were created successfully.");
        }
        catch (Exception e) {
            throw closer.rethrow((Throwable)e);
        }
        finally {
            try {
                closer.close();
            }
            catch (IOException e) {
                LOG.error("Error while flushing/closing Property Key CSV FileWriter", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public static void writeYMLFile(Collection<? extends PropertyKey> defaultKeys, String filePath) throws IOException {
        if (defaultKeys.size() == 0) {
            return;
        }
        Closer closer = Closer.create();
        String[] fileNames = new String[]{"user-configuration.yml", "master-configuration.yml", "worker-configuration.yml", "security-configuration.yml", "common-configuration.yml", "cluster-management-configuration.yml"};
        try {
            FileWriter fileWriter;
            void var8_11;
            HashMap<String, FileWriter> fileWriterMap = new HashMap<String, FileWriter>();
            String[] stringArray = fileNames;
            int n = stringArray.length;
            boolean bl = false;
            while (var8_11 < n) {
                String fileName = stringArray[var8_11];
                fileWriter = new FileWriter(PathUtils.concatPath((Object)filePath, (Object)fileName));
                String key = fileName.substring(0, fileName.indexOf("configuration") - 1);
                fileWriterMap.put(key, fileWriter);
                closer.register((Closeable)fileWriter);
                ++var8_11;
            }
            ArrayList<? extends PropertyKey> dfkeys = new ArrayList<PropertyKey>(defaultKeys);
            Collections.sort(dfkeys);
            for (PropertyKey propertyKey : dfkeys) {
                String pKey = propertyKey.toString();
                String description = propertyKey.getDescription().replace("'", "''");
                if (propertyKey.isIgnoredSiteProperty()) {
                    description = description + " Note: overwriting this property will only work when it is passed as a JVM system property (e.g., appending \"-D" + propertyKey + "\"=<NEW_VALUE>\" to $ALLUXIO_JAVA_OPTS). Setting it in alluxio-site.properties will not work.";
                }
                String keyValueStr = pKey + ":\n  '" + description + "'\n";
                fileWriter = pKey.startsWith("alluxio.user.") ? (FileWriter)fileWriterMap.get("user") : (pKey.startsWith("alluxio.master.") ? (FileWriter)fileWriterMap.get("master") : (pKey.startsWith("alluxio.worker.") ? (FileWriter)fileWriterMap.get("worker") : (pKey.startsWith("alluxio.security.") ? (FileWriter)fileWriterMap.get("security") : (pKey.startsWith("alluxio.integration.") ? (FileWriter)fileWriterMap.get("cluster-management") : (FileWriter)fileWriterMap.get("common")))));
                fileWriter.append(StringEscapeUtils.escapeHtml4((String)keyValueStr));
            }
            LOG.info("YML files for description of Property Keys were created successfully.");
        }
        catch (Exception e) {
            throw closer.rethrow((Throwable)e);
        }
        finally {
            try {
                closer.close();
            }
            catch (IOException e) {
                LOG.error("Error while flushing/closing YML files for description of Property Keys FileWriter", (Throwable)e);
            }
        }
    }

    public static void generate() throws IOException {
        Collection defaultKeys = PropertyKey.defaultKeys();
        defaultKeys.removeIf(PropertyKey::isHidden);
        String homeDir = Configuration.getString((PropertyKey)PropertyKey.HOME);
        String filePath = PathUtils.concatPath((Object)homeDir, (Object)CSV_FILE_DIR);
        ConfigurationDocGenerator.writeCSVFile(defaultKeys, filePath);
        filePath = PathUtils.concatPath((Object)homeDir, (Object)YML_FILE_DIR);
        ConfigurationDocGenerator.writeYMLFile(defaultKeys, filePath);
    }
}

