/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.bundler.command;

import alluxio.cli.bundler.command.AbstractCollectInfoCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.exception.AlluxioException;
import alluxio.shell.CommandReturn;
import alluxio.shell.ShellCommand;
import alluxio.util.ShellUtils;
import alluxio.util.SleepUtils;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectJvmInfoCommand
extends AbstractCollectInfoCommand {
    public static final String COMMAND_NAME = "collectJvmInfo";
    private static final Logger LOG = LoggerFactory.getLogger(CollectJvmInfoCommand.class);
    private static final int COLLECT_JSTACK_TIMES = 3;
    private static final int COLLECT_JSTACK_INTERVAL = 3000;

    public CollectJvmInfoCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return COMMAND_NAME;
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        this.mWorkingDirPath = this.getWorkingDirectory(cl);
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss");
        for (int i = 0; i < 3; ++i) {
            LocalDateTime now = LocalDateTime.now();
            String timeString = dtf.format(now);
            LOG.info(String.format("Collecting JVM info at %s", timeString));
            LOG.info("Checking current JPS");
            Map<String, String> procs = this.getJps();
            String jstackContent = this.dumpJstack(procs);
            File outputFile = this.generateOutputFile(this.mWorkingDirPath, String.format("%s-%s", this.getCommandName(), timeString));
            FileUtils.writeStringToFile((File)outputFile, (String)jstackContent);
            LOG.info(String.format("Wait for an interval of %s seconds", 3000));
            SleepUtils.sleepMs((Logger)LOG, (long)3000L);
        }
        return 0;
    }

    private Map<String, String> getJps() throws IOException {
        HashMap<String, String> procs = new HashMap<String, String>();
        ShellCommand sudoJpsCommand = new ShellCommand(new String[]{"sudo", "jps"});
        ShellCommand jpsCommand = new ShellCommand(new String[]{"jps"});
        CommandReturn cr = ShellUtils.execCmdWithBackup((ShellCommand)sudoJpsCommand, (ShellCommand)jpsCommand);
        if (cr.getExitCode() != 0) {
            LOG.warn(cr.getFormattedOutput());
            return procs;
        }
        LOG.info("JPS succeeded");
        int idx = 0;
        for (String row : cr.getOutput().split("\n")) {
            String[] parts = row.split(" ");
            if (parts.length == 0) {
                LOG.error(String.format("Failed to parse row %s", row));
                continue;
            }
            if (parts.length == 1) {
                LOG.info(String.format("Row %s has no process name", row));
                procs.put(parts[0], "unknown" + idx);
                ++idx;
                continue;
            }
            LOG.info(String.format("Found JVM %s %s", parts[0], parts[1]));
            procs.put(parts[0], parts[1]);
        }
        return procs;
    }

    private String dumpJstack(Map<String, String> procs) throws IOException {
        StringWriter outputBuffer = new StringWriter();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss");
        LocalDateTime now = LocalDateTime.now();
        String timeString = dtf.format(now);
        String timeMsg = String.format("Dumping jstack at approximately %s", timeString);
        LOG.info(timeMsg);
        outputBuffer.write(timeMsg);
        for (Map.Entry<String, String> entry : procs.entrySet()) {
            String pid = entry.getKey();
            String pname = entry.getValue();
            String jstackMsg = String.format("Jstack PID:%s Name:%s", pid, pname);
            LOG.info(jstackMsg);
            outputBuffer.write(jstackMsg);
            ShellCommand jstackCmd = new ShellCommand(new String[]{"jstack", pid});
            ShellCommand sudoJstackCmd = new ShellCommand(new String[]{"sudo", "jstack", pid});
            CommandReturn cr = ShellUtils.execCmdWithBackup((ShellCommand)jstackCmd, (ShellCommand)sudoJstackCmd);
            LOG.info("{} finished", (Object)Arrays.toString(cr.getCmd()));
            outputBuffer.write(cr.getFormattedOutput());
        }
        LOG.info("Jstack dump finished on all processes");
        return outputBuffer.toString();
    }

    public String getUsage() {
        return "collectJvmInfo <outputPath>";
    }

    public String getDescription() {
        return "Collect JVM information by collecting jstack";
    }
}

