/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.bundler.command;

import alluxio.cli.bundler.command.ExecuteShellCollectInfoCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.PropertyKey;
import alluxio.shell.ShellCommand;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectAlluxioInfoCommand
extends ExecuteShellCollectInfoCommand {
    public static final String COMMAND_NAME = "collectAlluxioInfo";
    private static final Logger LOG = LoggerFactory.getLogger(CollectAlluxioInfoCommand.class);
    private String mAlluxioPath;

    public CollectAlluxioInfoCommand(FileSystemContext fsContext) {
        super(fsContext);
        this.mAlluxioPath = Paths.get(fsContext.getClusterConf().getString(PropertyKey.WORK_DIR), "bin/alluxio").toAbsolutePath().toString();
        this.registerCommands();
    }

    @Override
    protected void registerCommands() {
        this.registerCommand("getConf", new AlluxioCommand(this.mAlluxioPath, "getConf"), null);
        this.registerCommand("getConf master", new AlluxioCommand(this.mAlluxioPath, "getConf --master --source"), null);
        this.registerCommand("fsadmin", new AlluxioCommand(this.mAlluxioPath, "fsadmin report"), null);
        this.registerCommand("mount", new AlluxioCommand(this.mAlluxioPath, "fs mount"), null);
        this.registerCommand("version", new AlluxioCommand(this.mAlluxioPath, "version -r"), null);
        this.registerCommand("job", new AlluxioCommand(this.mAlluxioPath, "job ls"), null);
        this.registerCommand("journal", new AlluxioCommand(this.mAlluxioPath, String.format("fs ls -R %s", this.mFsContext.getClusterConf().get(PropertyKey.MASTER_JOURNAL_FOLDER))), this.getListJournalCommand());
        this.registerCommand("runTests", new AlluxioCommand(this.mAlluxioPath, "runTests"), null);
        this.registerCommand("validateConf", new AlluxioCommand(this.mAlluxioPath, "validateConf"), null);
    }

    private ShellCommand getListJournalCommand() {
        String journalPath = this.mFsContext.getClusterConf().getString(PropertyKey.MASTER_JOURNAL_FOLDER);
        if (journalPath.startsWith("hdfs:")) {
            return new ShellCommand(new String[]{"hdfs", "dfs", "-ls", "-R", journalPath});
        }
        return new ShellCommand(new String[]{"ls", "-al", "-R", journalPath});
    }

    public String getCommandName() {
        return COMMAND_NAME;
    }

    public String getUsage() {
        return "collectAlluxioInfo <outputPath>";
    }

    public String getDescription() {
        return "Run a list of Alluxio commands to collect Alluxio cluster information";
    }

    public static class AlluxioCommand
    extends ShellCommand {
        public AlluxioCommand(String alluxioPath, String cmd) {
            super((alluxioPath + " " + cmd).split(" "));
        }
    }
}

