/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.AlluxioURI;
import alluxio.cli.BasicNonByteBufferOperations;
import alluxio.cli.BasicOperations;
import alluxio.cli.RunTestUtils;
import alluxio.client.ReadType;
import alluxio.client.WriteType;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.grpc.DeletePOptions;
import alluxio.util.io.PathUtils;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.internal.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class TestRunner {
    private static final List<ReadType> READ_TYPES = Arrays.asList(ReadType.CACHE_PROMOTE, ReadType.CACHE, ReadType.NO_CACHE);
    private static final List<WriteType> WRITE_TYPES = Arrays.asList(WriteType.MUST_CACHE, WriteType.CACHE_THROUGH, WriteType.THROUGH, WriteType.ASYNC_THROUGH);
    @Parameter(names={"--directory"}, description="Alluxio path for the tests working directory.")
    private String mDirectory = "/";
    @Parameter(names={"-h", "--help"}, description="Prints usage information", help=true)
    private boolean mHelp;
    @Parameter(names={"--operation"}, description="The operation to test, either BASIC or BASIC_NON_BYTE_BUFFER. By default both operations are tested.")
    private String mOperation;
    @Parameter(names={"--readType"}, description="The read type to use, one of NO_CACHE, CACHE, CACHE_PROMOTE. By default all readTypes are tested.")
    private String mReadType;
    @Parameter(names={"--writeType"}, description="The write type to use, one of MUST_CACHE, CACHE_THROUGH, THROUGH, ASYNC_THROUGH. By default all writeTypes are tested.")
    private String mWriteType;
    public static final String TEST_DIRECTORY_NAME = "default_tests_files";

    private TestRunner() {
    }

    public static void main(String[] args) throws Exception {
        TestRunner runner = new TestRunner();
        JCommander jCommander = new JCommander((Object)runner);
        jCommander.setProgramName("TestRunner");
        if (runner.mHelp) {
            jCommander.usage();
            return;
        }
        int ret = runner.runTests();
        System.exit(ret);
    }

    private int runTests() throws Exception {
        this.mDirectory = PathUtils.concatPath((Object)this.mDirectory, (Object)TEST_DIRECTORY_NAME);
        AlluxioURI testDir = new AlluxioURI(this.mDirectory);
        FileSystemContext fsContext = FileSystemContext.create();
        FileSystem fs = FileSystem.Factory.create((FileSystemContext)fsContext);
        if (fs.exists(testDir)) {
            fs.delete(testDir, DeletePOptions.newBuilder().setRecursive(true).setUnchecked(true).build());
        }
        int failed = 0;
        List readTypes = this.mReadType == null ? READ_TYPES : Lists.newArrayList((Object[])new ReadType[]{ReadType.valueOf((String)this.mReadType)});
        List writeTypes = this.mWriteType == null ? WRITE_TYPES : Lists.newArrayList((Object[])new WriteType[]{WriteType.valueOf((String)this.mWriteType)});
        List operations = this.mOperation == null ? Lists.newArrayList((Object[])OperationType.values()) : Lists.newArrayList((Object[])new OperationType[]{OperationType.valueOf(this.mOperation)});
        for (ReadType readType : readTypes) {
            for (WriteType writeType : writeTypes) {
                for (OperationType opType : operations) {
                    System.out.println(String.format("runTest --operation %s --readType %s --writeType %s", new Object[]{opType, readType, writeType}));
                    failed += this.runTest(opType, readType, writeType, fsContext);
                }
            }
        }
        if (failed > 0) {
            System.out.println("Number of failed tests: " + failed);
        }
        return failed;
    }

    private int runTest(OperationType opType, ReadType readType, WriteType writeType, FileSystemContext fsContext) {
        AlluxioURI filePath = new AlluxioURI(String.format("%s/%s_%s_%s", new Object[]{this.mDirectory, opType, readType, writeType}));
        boolean result = true;
        switch (opType) {
            case BASIC: {
                result = RunTestUtils.runExample((Callable)new BasicOperations(filePath, readType, writeType, fsContext));
                break;
            }
            case BASIC_NON_BYTE_BUFFER: {
                result = RunTestUtils.runExample((Callable)new BasicNonByteBufferOperations(filePath, readType, writeType, true, 20, fsContext));
                break;
            }
            default: {
                System.out.println("Unrecognized operation type " + (Object)((Object)opType));
            }
        }
        return result ? 0 : 1;
    }

    static enum OperationType {
        BASIC,
        BASIC_NON_BYTE_BUFFER;

    }
}

