/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.retry.ExponentialBackoffRetry;
import alluxio.retry.RetryPolicy;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.worker.WorkerHealthCheckClient;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AlluxioWorkerMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(AlluxioWorkerMonitor.class);
    public static final Supplier<RetryPolicy> ONE_MIN_EXP_BACKOFF = () -> new ExponentialBackoffRetry(50, 500, 120);

    public static void main(String[] args) {
        AlluxioConfiguration conf;
        WorkerHealthCheckClient client;
        if (args.length != 0) {
            LOG.info("java -cp {} {}", (Object)"target/alluxio-2.8.1-jar-with-dependencies.jar", (Object)AlluxioWorkerMonitor.class.getCanonicalName());
            LOG.warn("ignoring arguments");
        }
        if (!(client = new WorkerHealthCheckClient(NetworkAddressUtils.getConnectAddress((NetworkAddressUtils.ServiceAttributeProvider)NetworkAddressUtils.ServiceType.WORKER_RPC, (AlluxioConfiguration)(conf = Configuration.global())), ONE_MIN_EXP_BACKOFF, conf)).isServing()) {
            System.exit(1);
        }
        System.exit(0);
    }

    private AlluxioWorkerMonitor() {
    }
}

