/*
 * Decompiled with CFR 0.152.
 */
package alluxio.proxy;

import alluxio.HealthCheckClient;
import alluxio.retry.RetryPolicy;
import alluxio.util.network.NetworkAddressUtils;
import java.net.InetSocketAddress;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyHealthCheckClient
implements HealthCheckClient {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyHealthCheckClient.class);
    private final InetSocketAddress mProxyAddress;
    private final Supplier<RetryPolicy> mRetryPolicySupplier;

    public ProxyHealthCheckClient(InetSocketAddress proxyAddress, Supplier<RetryPolicy> retryPolicySupplier) {
        this.mProxyAddress = proxyAddress;
        this.mRetryPolicySupplier = retryPolicySupplier;
    }

    public boolean isServing() {
        RetryPolicy retry = this.mRetryPolicySupplier.get();
        while (retry.attempt()) {
            LOG.debug("Checking whether {} is listening", (Object)this.mProxyAddress);
            boolean connected = NetworkAddressUtils.isServing((String)this.mProxyAddress.getHostName(), (int)this.mProxyAddress.getPort());
            if (!connected) {
                LOG.debug("Failed to connect to {}", (Object)this.mProxyAddress);
                continue;
            }
            LOG.debug("Successfully connected to {}", (Object)this.mProxyAddress);
            return true;
        }
        return false;
    }
}

