/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.util;

import alluxio.client.job.JobMasterClient;
import alluxio.grpc.OperationType;
import alluxio.job.wire.CmdStatusBlock;
import alluxio.job.wire.SimpleJobStatusBlock;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class DistributedCommandUtil {
    public static void getDetailedCmdStatus(long jobControlId, JobMasterClient client, Set<String> failedFiles, List<String> completedFiles) throws IOException {
        CmdStatusBlock cmdStatus = client.getCmdStatusDetailed(jobControlId);
        List blockList = cmdStatus.getJobStatusBlock();
        List<SimpleJobStatusBlock> failedBlocks = blockList.stream().filter(block -> {
            String failed = block.getFilesPathFailed();
            return !failed.equals("") && failed != null;
        }).collect(Collectors.toList());
        failedBlocks.forEach(block -> {
            String[] files = block.getFilesPathFailed().split(",");
            failedFiles.addAll(Arrays.asList(files));
        });
        int failedCount = failedFiles.size();
        List nonEmptyPathBlocks = blockList.stream().filter(block -> {
            String path = block.getFilePath();
            return !path.equals("") && path != null;
        }).collect(Collectors.toList());
        nonEmptyPathBlocks.stream().forEach(block -> {
            String[] paths;
            for (String path : paths = block.getFilePath().split(",")) {
                if (failedFiles.contains(path)) continue;
                completedFiles.add(path);
            }
        });
        int completedCount = completedFiles.size();
        OperationType operationType = cmdStatus.getOperationType();
        String printKeyWord = operationType.equals((Object)OperationType.DIST_LOAD) ? "loaded" : (operationType.equals((Object)OperationType.DIST_CP) ? "copied" : "processed");
        if (cmdStatus.getJobStatusBlock().isEmpty()) {
            System.out.format("Unable to get command status for jobControlId=%s, please retry or use `fs ls` command to check if files are already loaded in Alluxio.%n", jobControlId);
        } else {
            System.out.format("Get command status information below: %n", new Object[0]);
            completedFiles.forEach(file -> System.out.format("Successfully %s path %s%n", printKeyWord, file));
            System.out.format("Total completed file count is %s, failed file count is %s%n", completedCount, failedCount);
        }
    }
}

