/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.job.command;

import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.client.job.JobContext;
import alluxio.client.job.JobMasterClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.AlluxioException;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.job.wire.JobInfo;
import alluxio.job.wire.TaskInfo;
import alluxio.resource.CloseableResource;
import alluxio.security.user.UserState;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class StatCommand
extends AbstractFileSystemCommand {
    private static final Logger LOG = LoggerFactory.getLogger(StatCommand.class);
    private static final Option VERBOSE_OPTION = Option.builder((String)"v").required(false).hasArg(false).desc("show the status of every task").build();

    public StatCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "stat";
    }

    public Options getOptions() {
        return new Options().addOption(VERBOSE_OPTION);
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        long id = Long.parseLong(cl.getArgs()[0]);
        try (CloseableResource client = JobContext.create((AlluxioConfiguration)this.mFsContext.getClusterConf(), (UserState)this.mFsContext.getClientContext().getUserState()).acquireMasterClientResource();){
            JobInfo info = ((JobMasterClient)client.get()).getJobStatusDetailed(id);
            System.out.print(this.formatOutput(cl, info));
        }
        catch (Exception e) {
            LOG.error("Failed to get status of the job", (Throwable)e);
            System.out.println("Failed to get status of the job " + id);
            return -1;
        }
        return 0;
    }

    private String formatOutput(CommandLine cl, JobInfo info) {
        StringBuilder output = new StringBuilder();
        output.append("ID: ").append(info.getId()).append("\n");
        output.append("Name: ").append(info.getName()).append("\n");
        output.append("Description: ");
        if (cl.hasOption("v")) {
            output.append(info.getDescription());
        } else {
            output.append(StringUtils.abbreviate((String)info.getDescription(), (int)200));
        }
        output.append("\n");
        output.append("Status: ").append(info.getStatus()).append("\n");
        if (info.getErrorMessage() != null && !info.getErrorMessage().isEmpty()) {
            output.append("Error: ").append(info.getErrorMessage()).append("\n");
        }
        if (info.getResult() != null && !info.getResult().toString().isEmpty()) {
            output.append("Result: ").append(info.getResult().toString()).append("\n");
        }
        if (cl.hasOption("v")) {
            for (JobInfo childInfo : info.getChildren()) {
                TaskInfo taskInfo;
                output.append("Task ").append(childInfo.getId()).append("\n");
                if (childInfo instanceof TaskInfo && (taskInfo = (TaskInfo)childInfo).getWorkerHost() != null) {
                    output.append("\t").append("Worker: ").append(taskInfo.getWorkerHost()).append("\n");
                }
                if (!childInfo.getDescription().isEmpty()) {
                    output.append("\t").append("Description: ").append(StringUtils.abbreviate((String)childInfo.getDescription(), (int)200)).append("\n");
                }
                output.append("\t").append("Status: ").append(childInfo.getStatus()).append("\n");
                if (childInfo.getErrorMessage() != null && !childInfo.getErrorMessage().isEmpty()) {
                    output.append("\t").append("Error: ").append(childInfo.getErrorMessage()).append("\n");
                }
                if (childInfo.getResult() == null) continue;
                output.append("\t").append("Result: ").append(childInfo.getResult()).append("\n");
            }
        }
        return output.toString();
    }

    public String getUsage() {
        return "stat [-v] <id>";
    }

    public String getDescription() {
        return "Displays the status info for the specific job. Use -v flag to display the status of every task";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)1);
        String arg = cl.getArgs()[0];
        try {
            Long.parseLong(arg);
        }
        catch (Exception e) {
            throw new InvalidArgumentException(ExceptionMessage.INVALID_ARG_TYPE.getMessage(new Object[]{arg, "long"}));
        }
    }
}

