/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.job.command;

import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.client.job.JobContext;
import alluxio.client.job.JobMasterClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.resource.CloseableResource;
import alluxio.security.user.UserState;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CancelCommand
extends AbstractFileSystemCommand {
    private static final Logger LOG = LoggerFactory.getLogger(CancelCommand.class);

    public CancelCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "cancel";
    }

    public String getUsage() {
        return "cancel <id>";
    }

    public String getDescription() {
        return "Cancels a job asynchronously.";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)1);
        String arg = cl.getArgs()[0];
        try {
            Long.parseLong(arg);
        }
        catch (Exception e) {
            throw new InvalidArgumentException(ExceptionMessage.INVALID_ARG_TYPE.getMessage(new Object[]{arg, "long"}));
        }
    }

    public int run(CommandLine cl) {
        long id = Long.parseLong(cl.getArgs()[0]);
        try (CloseableResource client = JobContext.create((AlluxioConfiguration)this.mFsContext.getClusterConf(), (UserState)this.mFsContext.getClientContext().getUserState()).acquireMasterClientResource();){
            ((JobMasterClient)client.get()).cancel(id);
        }
        catch (Exception e) {
            LOG.error("Failed to cancel the job", (Throwable)e);
            System.out.println("Failed to cancel the job " + id);
            return -1;
        }
        return 0;
    }
}

