/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fsadmin.report;

import alluxio.cli.fsadmin.FileSystemAdminShellUtils;
import alluxio.client.block.BlockMasterClient;
import alluxio.client.meta.MetaMasterClient;
import alluxio.grpc.MasterInfo;
import alluxio.grpc.MasterInfoField;
import alluxio.util.CommonUtils;
import alluxio.util.FormatUtils;
import alluxio.wire.BlockMasterInfo;
import com.google.common.base.Strings;
import com.google.protobuf.ProtocolStringList;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;

public class SummaryCommand {
    private static final int INDENT_SIZE = 4;
    private int mIndentationLevel = 0;
    private MetaMasterClient mMetaMasterClient;
    private BlockMasterClient mBlockMasterClient;
    private PrintStream mPrintStream;
    private final String mDateFormatPattern;

    public SummaryCommand(MetaMasterClient metaMasterClient, BlockMasterClient blockMasterClient, String dateFormatPattern, PrintStream printStream) {
        this.mMetaMasterClient = metaMasterClient;
        this.mBlockMasterClient = blockMasterClient;
        this.mPrintStream = printStream;
        this.mDateFormatPattern = dateFormatPattern;
    }

    public int run() throws IOException {
        this.print("Alluxio cluster summary: ");
        this.printMetaMasterInfo();
        this.printBlockMasterInfo();
        return 0;
    }

    private void printMetaMasterInfo() throws IOException {
        ++this.mIndentationLevel;
        HashSet<MasterInfoField> masterInfoFilter = new HashSet<MasterInfoField>(Arrays.asList(MasterInfoField.LEADER_MASTER_ADDRESS, MasterInfoField.WEB_PORT, MasterInfoField.RPC_PORT, MasterInfoField.START_TIME_MS, MasterInfoField.UP_TIME_MS, MasterInfoField.VERSION, MasterInfoField.SAFE_MODE, MasterInfoField.ZOOKEEPER_ADDRESSES, MasterInfoField.RAFT_JOURNAL, MasterInfoField.RAFT_ADDRESSES));
        MasterInfo masterInfo = this.mMetaMasterClient.getMasterInfo(masterInfoFilter);
        this.print("Master Address: " + masterInfo.getLeaderMasterAddress());
        this.print("Web Port: " + masterInfo.getWebPort());
        this.print("Rpc Port: " + masterInfo.getRpcPort());
        this.print("Started: " + CommonUtils.convertMsToDate((long)masterInfo.getStartTimeMs(), (String)this.mDateFormatPattern));
        this.print("Uptime: " + CommonUtils.convertMsToClockTime((long)masterInfo.getUpTimeMs()));
        this.print("Version: " + masterInfo.getVersion());
        this.print("Safe Mode: " + masterInfo.getSafeMode());
        ProtocolStringList zookeeperAddresses = masterInfo.getZookeeperAddressesList();
        if (zookeeperAddresses == null || zookeeperAddresses.isEmpty()) {
            this.print("Zookeeper Enabled: false");
        } else {
            this.print("Zookeeper Enabled: true");
            this.print("Zookeeper Addresses: ");
            ++this.mIndentationLevel;
            for (String zkAddress : zookeeperAddresses) {
                this.print(zkAddress);
            }
            --this.mIndentationLevel;
        }
        if (masterInfo.getRaftJournal()) {
            this.print("Raft-based Journal: true");
            this.print("Raft Journal Addresses: ");
            ++this.mIndentationLevel;
            for (String raftAddress : masterInfo.getRaftAddressList()) {
                this.print(raftAddress);
            }
            --this.mIndentationLevel;
        } else {
            this.print("Raft-based Journal: false");
        }
    }

    private void printBlockMasterInfo() throws IOException {
        HashSet<BlockMasterInfo.BlockMasterInfoField> blockMasterInfoFilter = new HashSet<BlockMasterInfo.BlockMasterInfoField>(Arrays.asList(BlockMasterInfo.BlockMasterInfoField.LIVE_WORKER_NUM, BlockMasterInfo.BlockMasterInfoField.LOST_WORKER_NUM, BlockMasterInfo.BlockMasterInfoField.CAPACITY_BYTES, BlockMasterInfo.BlockMasterInfoField.USED_BYTES, BlockMasterInfo.BlockMasterInfoField.FREE_BYTES, BlockMasterInfo.BlockMasterInfoField.CAPACITY_BYTES_ON_TIERS, BlockMasterInfo.BlockMasterInfoField.USED_BYTES_ON_TIERS));
        BlockMasterInfo blockMasterInfo = this.mBlockMasterClient.getBlockMasterInfo(blockMasterInfoFilter);
        this.print("Live Workers: " + blockMasterInfo.getLiveWorkerNum());
        this.print("Lost Workers: " + blockMasterInfo.getLostWorkerNum());
        this.print("Total Capacity: " + FormatUtils.getSizeFromBytes((long)blockMasterInfo.getCapacityBytes()));
        ++this.mIndentationLevel;
        TreeMap totalCapacityOnTiers = new TreeMap((a, b) -> FileSystemAdminShellUtils.compareTierNames(a, b));
        totalCapacityOnTiers.putAll(blockMasterInfo.getCapacityBytesOnTiers());
        for (Map.Entry capacityBytesTier : totalCapacityOnTiers.entrySet()) {
            this.print("Tier: " + (String)capacityBytesTier.getKey() + "  Size: " + FormatUtils.getSizeFromBytes((long)((Long)capacityBytesTier.getValue())));
        }
        --this.mIndentationLevel;
        this.print("Used Capacity: " + FormatUtils.getSizeFromBytes((long)blockMasterInfo.getUsedBytes()));
        ++this.mIndentationLevel;
        TreeMap usedCapacityOnTiers = new TreeMap((a, b) -> FileSystemAdminShellUtils.compareTierNames(a, b));
        usedCapacityOnTiers.putAll(blockMasterInfo.getUsedBytesOnTiers());
        for (Map.Entry usedBytesTier : usedCapacityOnTiers.entrySet()) {
            this.print("Tier: " + (String)usedBytesTier.getKey() + "  Size: " + FormatUtils.getSizeFromBytes((long)((Long)usedBytesTier.getValue())));
        }
        --this.mIndentationLevel;
        this.print("Free Capacity: " + FormatUtils.getSizeFromBytes((long)blockMasterInfo.getFreeBytes()));
    }

    private void print(String text) {
        String indent = Strings.repeat((String)" ", (int)(this.mIndentationLevel * 4));
        this.mPrintStream.println(indent + text);
    }
}

