/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fsadmin.pathconf;

import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fsadmin.command.AbstractFsAdminCommand;
import alluxio.cli.fsadmin.command.Context;
import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.GetConfigurationPOptions;
import alluxio.wire.Configuration;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.cli.CommandLine;

public final class ListCommand
extends AbstractFsAdminCommand {
    public ListCommand(Context context, AlluxioConfiguration alluxioConf) {
        super(context);
    }

    public String getCommandName() {
        return "list";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)0);
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        Configuration conf = this.mMetaConfigClient.getConfiguration(GetConfigurationPOptions.newBuilder().setIgnoreClusterConf(true).build());
        ArrayList paths = new ArrayList(conf.getPathConf().keySet());
        Collections.sort(paths);
        for (String path : paths) {
            this.mPrintStream.println(path);
        }
        return 0;
    }

    public String getUsage() {
        return "list";
    }

    @VisibleForTesting
    public static String description() {
        return "List paths that have path level configuration.";
    }

    public String getDescription() {
        return ListCommand.description();
    }
}

