/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fsadmin.journal;

import alluxio.cli.fsadmin.command.AbstractFsAdminCommand;
import alluxio.cli.fsadmin.command.Context;
import alluxio.cli.fsadmin.journal.QuorumCommand;
import alluxio.client.journal.JournalMasterClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.GetQuorumInfoPResponse;
import alluxio.grpc.NetAddress;
import alluxio.grpc.QuorumServerInfo;
import alluxio.util.CommonUtils;
import alluxio.util.WaitForOptions;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class QuorumElectCommand
extends AbstractFsAdminCommand {
    public static final String ADDRESS_OPTION_NAME = "address";
    public static final String TRANSFER_INIT = "Initiating transfer of leadership to %s";
    public static final String TRANSFER_SUCCESS = "Successfully elected %s as the new leader";
    public static final String TRANSFER_FAILED = "Failed to elect %s as the new leader: %s";
    public static final String RESET_INIT = "Resetting priorities of masters after %s transfer of leadership";
    public static final String RESET_SUCCESS = "Quorum priorities were reset to 1";
    public static final String RESET_FAILED = "Quorum priorities failed to be reset: %s";

    public QuorumElectCommand(Context context, AlluxioConfiguration alluxioConf) {
        super(context);
    }

    @VisibleForTesting
    public static String description() {
        return "Transfers leadership of the quorum to the master located at <hostname>:<port>";
    }

    public int run(CommandLine cl) throws IOException {
        JournalMasterClient jmClient = this.mMasterJournalMasterClient;
        String serverAddress = cl.getOptionValue(ADDRESS_OPTION_NAME);
        NetAddress address = QuorumCommand.stringToAddress(serverAddress);
        boolean success = false;
        try {
            this.mPrintStream.println(String.format(TRANSFER_INIT, serverAddress));
            String transferId = jmClient.transferLeadership(address);
            AtomicReference<String> errorMessage = new AtomicReference<String>("");
            int TIMEOUT_3MIN = 180000;
            CommonUtils.waitFor((String)"election to finalize.", () -> {
                try {
                    errorMessage.set(jmClient.getTransferLeaderMessage(transferId).getTransMsg().getMsg());
                    if (!((String)errorMessage.get()).isEmpty()) {
                        return true;
                    }
                    GetQuorumInfoPResponse quorumInfo = jmClient.getQuorumInfo();
                    Optional<QuorumServerInfo> leadingMasterInfoOpt = quorumInfo.getServerInfoList().stream().filter(QuorumServerInfo::getIsLeader).findFirst();
                    NetAddress leaderAddress = leadingMasterInfoOpt.isPresent() ? leadingMasterInfoOpt.get().getServerAddress() : null;
                    return address.equals((Object)leaderAddress);
                }
                catch (IOException e) {
                    return false;
                }
            }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(180000));
            if (!errorMessage.get().isEmpty()) {
                throw new Exception(errorMessage.get());
            }
            this.mPrintStream.println(String.format(TRANSFER_SUCCESS, serverAddress));
            success = true;
        }
        catch (Exception e) {
            this.mPrintStream.println(String.format(TRANSFER_FAILED, serverAddress, e.getMessage()));
        }
        try {
            this.mPrintStream.println(String.format(RESET_INIT, success ? "successful" : "failed"));
            jmClient.resetPriorities();
            this.mPrintStream.println(RESET_SUCCESS);
        }
        catch (IOException e) {
            this.mPrintStream.println(String.format(RESET_FAILED, e));
            success = false;
        }
        return success ? 0 : -1;
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        if (!cl.hasOption(ADDRESS_OPTION_NAME)) {
            throw new InvalidArgumentException(ExceptionMessage.INVALID_OPTION.getMessage(new Object[]{String.format("[%s]", ADDRESS_OPTION_NAME)}));
        }
    }

    public String getCommandName() {
        return "elect";
    }

    public String getUsage() {
        return String.format("%s -%s <HOSTNAME:PORT>", this.getCommandName(), ADDRESS_OPTION_NAME);
    }

    public String getDescription() {
        return QuorumElectCommand.description();
    }

    public Options getOptions() {
        return new Options().addOption(ADDRESS_OPTION_NAME, true, "Server address that will take over as leader");
    }
}

