/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fsadmin.command;

import alluxio.cli.fsadmin.command.AbstractFsAdminCommand;
import alluxio.cli.fsadmin.command.Context;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class UpdateConfCommand
extends AbstractFsAdminCommand {
    public UpdateConfCommand(Context context, AlluxioConfiguration alluxioConf) {
        super(context);
    }

    public String getCommandName() {
        return "updateConf";
    }

    public int run(CommandLine cl) throws IOException {
        int errorCode = 0;
        HashMap<PropertyKey, String> properties = new HashMap<PropertyKey, String>();
        for (String arg : cl.getArgList()) {
            if (!arg.contains("=")) continue;
            String[] kv = arg.split("=");
            if (kv.length != 2) {
                System.err.println("Failed to parse %s, expecting argument in the format of \"key=val\", arg)");
                return -3;
            }
            properties.put(PropertyKey.getOrBuildCustom((String)kv[0]), kv[1]);
        }
        if (properties.size() == 0) {
            System.out.println("No config to update");
            return -1;
        }
        Map result = this.mMetaConfigClient.updateConfiguration(properties);
        System.out.println("Updated " + result.size() + " configs");
        for (Map.Entry entry : result.entrySet()) {
            if (((Boolean)entry.getValue()).booleanValue()) continue;
            System.out.println("Failed to Update " + ((PropertyKey)entry.getKey()).getName());
            errorCode = -2;
        }
        return errorCode;
    }

    public String getUsage() {
        return "updateConf key1=val1 [key2=val2 ...]";
    }

    @VisibleForTesting
    public static String description() {
        return "Update config for alluxio master.";
    }

    public String getDescription() {
        return UpdateConfCommand.description();
    }
}

