/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fsadmin;

import alluxio.ClientContext;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.FileSystemMasterClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.status.UnavailableException;
import alluxio.master.PollingMasterInquireClient;
import alluxio.resource.CloseableResource;
import alluxio.retry.ExponentialBackoffRetry;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;

public final class FileSystemAdminShellUtils {
    private FileSystemAdminShellUtils() {
    }

    public static int compareTierNames(String a, String b) {
        int bValue;
        int aValue = FileSystemAdminShellUtils.getTierRankValue(a);
        if (aValue == (bValue = FileSystemAdminShellUtils.getTierRankValue(b))) {
            return a.compareTo(b);
        }
        return aValue - bValue;
    }

    public static void checkMasterClientService(AlluxioConfiguration alluxioConf) throws IOException {
        try (FileSystemContext context = FileSystemContext.create((ClientContext)ClientContext.create((AlluxioConfiguration)alluxioConf));
             CloseableResource client = context.acquireMasterClientResource();){
            InetSocketAddress address = (InetSocketAddress)((FileSystemMasterClient)client.get()).getRemoteSockAddress();
            List<InetSocketAddress> addresses = Arrays.asList(address);
            PollingMasterInquireClient inquireClient = new PollingMasterInquireClient(addresses, () -> new ExponentialBackoffRetry(50, 100, 2), alluxioConf);
            inquireClient.getPrimaryRpcAddress();
        }
        catch (UnavailableException e) {
            throw new IOException("Cannot connect to Alluxio leader master.");
        }
    }

    private static int getTierRankValue(String input) {
        List<String> tierOrder = Arrays.asList("MEM", "SSD", "HDD");
        int rank = tierOrder.indexOf(input);
        if (rank == -1) {
            return Integer.MAX_VALUE;
        }
        return rank;
    }
}

