/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.cli.fs.command.FileSystemCommandUtils;
import alluxio.client.file.FileSystemContext;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.TtlAction;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;

@ThreadSafe
public final class UnsetTtlCommand
extends AbstractFileSystemCommand {
    public UnsetTtlCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return "unsetTtl";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)1);
    }

    @Override
    protected void runPlainPath(AlluxioURI inputPath, CommandLine cl) throws AlluxioException, IOException {
        FileSystemCommandUtils.setTtl(this.mFileSystem, inputPath, -1L, TtlAction.DELETE);
        System.out.println("TTL of file '" + inputPath + "' was successfully removed.");
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        String[] args = cl.getArgs();
        AlluxioURI inputPath = new AlluxioURI(args[0]);
        this.runWildCardCmd(inputPath, cl);
        return 0;
    }

    public String getUsage() {
        return "unsetTtl <path>";
    }

    public String getDescription() {
        return "Unsets the TTL value for the given path.";
    }
}

